/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt.booster;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.items.toolbelt.UtilToolbelt;
import se.mickelus.tetra.items.toolbelt.booster.UtilBooster;

public class TickHandlerBooster {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack itemStack = UtilToolbelt.findToolbelt(event.player);
        int level = UtilBooster.getBoosterLevel(itemStack);
        if (level > 0) {
            this.tickItem(event.player, itemStack, level);
        }
    }

    public void tickItem(EntityPlayer player, ItemStack stack, int level) {
        NBTTagCompound tag = NBTHelper.getTag(stack);
        boolean charged = tag.func_74767_n("booster.charged");
        if (!player.func_70090_H() && UtilBooster.isActive(tag) && UtilBooster.hasFuel(tag, charged)) {
            if (charged) {
                UtilBooster.boostPlayerCharged(player, tag, level);
            } else {
                UtilBooster.boostPlayer(player, tag, level);
            }
            UtilBooster.consumeFuel(tag, charged);
        } else {
            UtilBooster.rechargeFuel(tag, stack);
        }
        if (charged) {
            tag.func_74757_a("booster.charged", false);
        }
    }
}

