/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import se.mickelus.tetra.gui.GuiRoot;
import se.mickelus.tetra.items.toolbelt.gui.OverlayGuiPotionGroup;
import se.mickelus.tetra.items.toolbelt.gui.OverlayGuiQuickslotGroup;
import se.mickelus.tetra.items.toolbelt.gui.OverlayGuiQuiverGroup;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryPotions;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryQuickslot;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryQuiver;
import se.mickelus.tetra.items.toolbelt.inventory.ToolbeltSlotType;

public class OverlayGuiToolbelt
extends GuiRoot {
    private static final ResourceLocation toolbeltTexture = new ResourceLocation("tetra", "textures/gui/toolbelt-inventory.png");
    private OverlayGuiQuickslotGroup quickslotGroup;
    private OverlayGuiPotionGroup potionGroup;
    private OverlayGuiQuiverGroup quiverGroup;
    private boolean hasMouseMoved = false;
    private ScaledResolution scaledResolution;

    public OverlayGuiToolbelt(Minecraft mc) {
        super(mc);
        this.scaledResolution = new ScaledResolution(mc);
        this.quickslotGroup = new OverlayGuiQuickslotGroup(37, 0);
        this.addChild(this.quickslotGroup);
        this.potionGroup = new OverlayGuiPotionGroup(0, 30);
        this.addChild(this.potionGroup);
        this.quiverGroup = new OverlayGuiQuiverGroup(-30, -30);
        this.addChild(this.quiverGroup);
    }

    public void setInventories(ItemStack itemStack) {
        this.quickslotGroup.setInventory(new InventoryQuickslot(itemStack));
        this.potionGroup.setInventory(new InventoryPotions(itemStack));
        this.quiverGroup.setInventory(new InventoryQuiver(itemStack));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.scaledResolution = new ScaledResolution(this.mc);
            this.hasMouseMoved = false;
            this.quickslotGroup.setVisible(true);
            this.potionGroup.setVisible(true);
            this.quiverGroup.setVisible(true);
        } else {
            this.quickslotGroup.setVisible(false);
            this.potionGroup.setVisible(false);
            this.quiverGroup.setVisible(false);
        }
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            int mouseY;
            int mouseX;
            if (!(this.hasMouseMoved || Mouse.getDX() <= 0 && Mouse.getDY() <= 0)) {
                this.hasMouseMoved = true;
            }
            int width = this.scaledResolution.func_78326_a();
            int height = this.scaledResolution.func_78328_b();
            if (this.hasMouseMoved) {
                mouseX = Mouse.getX() * width / this.mc.field_71443_c;
                mouseY = height - Mouse.getY() * height / this.mc.field_71440_d - 1;
            } else {
                mouseX = width / 2;
                mouseY = height / 2;
            }
            this.drawChildren(width / 2, height / 2, width, height, mouseX, mouseY, 1.0f);
        }
    }

    public ToolbeltSlotType getFocusType() {
        if (this.quickslotGroup.getFocus() != -1) {
            return ToolbeltSlotType.quickslot;
        }
        if (this.potionGroup.getFocus() != -1) {
            return ToolbeltSlotType.potion;
        }
        if (this.quiverGroup.getFocus() != -1) {
            return ToolbeltSlotType.quiver;
        }
        return ToolbeltSlotType.quickslot;
    }

    public int getFocusIndex() {
        int quickslotFocus = this.quickslotGroup.getFocus();
        if (quickslotFocus != -1) {
            return quickslotFocus;
        }
        int potionFocus = this.potionGroup.getFocus();
        if (potionFocus != -1) {
            return potionFocus;
        }
        int quiverFocus = this.quiverGroup.getFocus();
        if (quiverFocus != -1) {
            return quiverFocus;
        }
        return -1;
    }
}

