/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt.inventory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.ItemPredicateComposite;
import se.mickelus.tetra.items.toolbelt.ItemToolbeltModular;
import se.mickelus.tetra.items.toolbelt.SlotType;
import se.mickelus.tetra.module.ItemEffect;

public class InventoryToolbelt
implements IInventory {
    protected static final String slotKey = "slot";
    protected ItemStack toolbeltItemStack;
    protected SlotType inventoryType;
    protected final String inventoryKey;
    protected NonNullList<ItemStack> inventoryContents;
    protected int numSlots = 0;
    protected int maxSize = 0;
    ItemPredicate predicate = ItemPredicate.field_192495_a;
    public static ItemPredicate potionPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate quickPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate quiverPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate storagePredicate = ItemPredicate.field_192495_a;

    public InventoryToolbelt(String inventoryKey, ItemStack stack, int maxSize, SlotType inventoryType) {
        this.inventoryKey = inventoryKey;
        this.toolbeltItemStack = stack;
        this.inventoryType = inventoryType;
        this.maxSize = maxSize;
        this.inventoryContents = NonNullList.func_191197_a((int)maxSize, (Object)ItemStack.field_190927_a);
    }

    public static void initializePredicates() {
        potionPredicate = InventoryToolbelt.getPredicate("potion");
        quickPredicate = InventoryToolbelt.getPredicate("quick");
        quiverPredicate = InventoryToolbelt.getPredicate("quiver");
        storagePredicate = InventoryToolbelt.getPredicate("storage");
    }

    private static ItemPredicate getPredicate(String inventory) {
        ItemPredicate[] predicates = (ItemPredicate[])Arrays.stream((Object[])DataHandler.instance.getData(String.format("toolbelt/%s_predicates", inventory), ItemPredicate[].class)).filter(Objects::nonNull).toArray(ItemPredicate[]::new);
        if (predicates.length > 0) {
            return new ItemPredicateComposite(predicates);
        }
        return ItemPredicate.field_192495_a;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c(this.inventoryKey, 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            int slot = itemTag.func_74762_e(slotKey);
            if (0 > slot || slot >= this.maxSize) continue;
            this.inventoryContents.set(slot, (Object)new ItemStack(itemTag));
        }
    }

    public void writeToNBT(NBTTagCompound tagcompound) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.maxSize; ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a(slotKey, i);
            this.func_70301_a(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tagcompound.func_74782_a(this.inventoryKey, (NBTBase)items);
    }

    public int func_70302_i_() {
        return this.numSlots;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = (ItemStack)this.inventoryContents.get(index);
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
        return itemStack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inventoryContents.set(i, (Object)ItemStack.field_190927_a);
        }
        this.writeToNBT(NBTHelper.getTag(this.toolbeltItemStack));
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public ItemStack takeItemStack(int index) {
        ItemStack itemStack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return itemStack;
    }

    public void emptyOverflowSlots(EntityPlayer player) {
        for (int i = this.func_70302_i_(); i < this.maxSize; ++i) {
            this.moveStackToPlayer(this.func_70304_b(i), player);
        }
        this.func_70296_d();
    }

    protected void moveStackToPlayer(ItemStack itemStack, EntityPlayer player) {
        if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
            player.func_71019_a(itemStack, false);
        }
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.predicate.func_192493_a(itemStack);
    }

    public boolean storeItemInInventory(ItemStack itemStack) {
        int i;
        if (!this.isItemValid(itemStack)) {
            return false;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack storedStack = this.func_70301_a(i);
            if (!storedStack.func_77969_a(itemStack) || storedStack.func_190916_E() >= storedStack.func_77976_d()) continue;
            int moveCount = Math.min(itemStack.func_190916_E(), storedStack.func_77976_d() - storedStack.func_190916_E());
            storedStack.func_190917_f(moveCount);
            this.func_70299_a(i, storedStack);
            itemStack.func_190918_g(moveCount);
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, itemStack);
            return true;
        }
        return false;
    }

    public int getFirstIndexForItem(Item item) {
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b() || !((ItemStack)this.inventoryContents.get(i)).func_77973_b().equals(item)) continue;
            return i;
        }
        return -1;
    }

    public List<Collection<ItemEffect>> getSlotEffects() {
        return ItemToolbeltModular.instance.getSlotEffects(this.toolbeltItemStack, this.inventoryType);
    }

    public static void setPredicates(ItemPredicate[] predicates) {
    }
}

