/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemEffect;

public class FortuneBonusCondition
implements LootCondition {
    private float chance;
    private float fortuneMultiplier;
    private Capability requiredCapability;
    private int capabilityLevel = -1;

    public boolean func_186618_a(Random rand, LootContext context) {
        ItemStack itemStack;
        int fortuneLevel = 0;
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        if (player != null && this.requiredCapability != null && !(itemStack = CapabilityHelper.getProvidingItemStack(this.requiredCapability, this.capabilityLevel, player)).func_190926_b() && itemStack.func_77973_b() instanceof ItemModular) {
            fortuneLevel = ((ItemModular)itemStack.func_77973_b()).getEffectLevel(itemStack, ItemEffect.fortune);
        }
        return rand.nextFloat() < this.chance + (float)fortuneLevel * this.fortuneMultiplier;
    }

    public static class Serializer
    extends LootCondition.Serializer<FortuneBonusCondition> {
        public Serializer() {
            super(new ResourceLocation("tetra:random_chance_with_fortune"), FortuneBonusCondition.class);
        }

        public void serialize(JsonObject json, FortuneBonusCondition value, JsonSerializationContext context) {
            DataHandler.instance.gson.toJsonTree((Object)value).getAsJsonObject().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }

        public FortuneBonusCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return (FortuneBonusCondition)DataHandler.instance.gson.fromJson((JsonElement)json, FortuneBonusCondition.class);
        }
    }
}

