/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.mickelus.tetra.PotionEarthbound;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.ItemModularHandheld;
import se.mickelus.tetra.items.toolbelt.UtilToolbelt;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryQuiver;
import se.mickelus.tetra.module.ItemEffect;

public class ItemEffectHandler {
    private Cache<UUID, Integer> strikeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static ItemEffectHandler instance;
    private static final BlockPos[] sweep1;
    private static final BlockPos[] sweep2;

    public ItemEffectHandler() {
        instance = this;
    }

    private int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        return item.getEffectLevel(itemStack, effect);
    }

    private double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        return item.getEffectEfficiency(itemStack, effect);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        Optional.ofNullable(event.getAttackingPlayer()).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int intuitLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.intuit);
            int xp = event.getDroppedExperience();
            if (intuitLevel > 0 && xp > 0) {
                ((ItemModular)itemStack.func_77973_b()).tickHoningProgression((EntityLivingBase)event.getAttackingPlayer(), (ItemStack)itemStack, intuitLevel * xp);
            }
        });
    }

    @SubscribeEvent
    public void onLootingLevel(LootingLevelEvent event) {
        Optional.ofNullable(event.getDamageSource().func_76346_g()).filter(entity -> entity instanceof EntityPlayer).map(entity -> (EntityLivingBase)entity).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> event.setLootingLevel(this.getEffectLevel((ItemStack)itemStack, ItemEffect.looting) + event.getLootingLevel()));
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof EntityPlayer).map(entity -> (EntityLivingBase)entity).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int quickStrikeLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.quickStrike);
            if (quickStrikeLevel > 0) {
                float maxDamage = (float)((EntityLivingBase)event.getSource().func_76346_g()).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                float multiplier = (float)quickStrikeLevel * 0.05f + 0.2f;
                if (event.getAmount() < multiplier * maxDamage) {
                    event.setAmount(multiplier * maxDamage);
                }
            }
            if (EnumCreatureAttribute.UNDEAD.equals((Object)event.getEntityLiving().func_70668_bt())) {
                event.setAmount(event.getAmount() + (float)this.getEffectLevel((ItemStack)itemStack, ItemEffect.smite) * 2.5f);
            }
            if (EnumCreatureAttribute.ARTHROPOD.equals((Object)event.getEntityLiving().func_70668_bt())) {
                event.setAmount(event.getAmount() + (float)this.getEffectLevel((ItemStack)itemStack, ItemEffect.arthropod) * 2.5f);
            }
        });
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof EntityPlayer).map(entity -> (EntityLivingBase)entity).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int unarmoredBonusLevel;
            int penetratingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.armorPenetration);
            if (penetratingLevel > 0 && event.getAmount() < (float)penetratingLevel) {
                event.setAmount((float)penetratingLevel);
            }
            if ((unarmoredBonusLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.unarmoredDamage)) > 0 && event.getEntityLiving().func_70658_aO() == 0) {
                event.setAmount(event.getAmount() + (float)unarmoredBonusLevel);
            }
        });
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Optional.ofNullable(event.getEntityLiving().func_70660_b((Potion)PotionEarthbound.instance)).ifPresent(effect -> event.getEntityLiving().field_70181_x *= 0.5);
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        Optional.ofNullable(event.getEntityLiving()).filter(entity -> entity instanceof EntityPlayer).map(entity -> entity).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int critLevel;
            int backstabLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.backstab);
            if (backstabLevel > 0 && event.getTarget() instanceof EntityLivingBase) {
                EntityLivingBase attacker = event.getEntityLiving();
                EntityLivingBase target = (EntityLivingBase)event.getTarget();
                if (180.0f - Math.abs(Math.abs(attacker.field_70759_as - target.field_70759_as) % 360.0f - 180.0f) < 60.0f) {
                    event.setDamageModifier(Math.max(1.25f + 0.25f * (float)backstabLevel, event.getDamageModifier()));
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if ((critLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.criticalStrike)) > 0 && (double)event.getEntityLiving().func_70681_au().nextFloat() < (double)critLevel * 0.01) {
                event.setDamageModifier(Math.max((float)this.getEffectEfficiency((ItemStack)itemStack, ItemEffect.criticalStrike), event.getDamageModifier()));
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public void onPlayerPickupXp(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Stream.concat(player.field_71071_by.field_70462_a.stream(), player.field_71071_by.field_184439_c.stream()).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).filter(ItemStack::func_77951_h).filter(itemStack -> this.getEffectLevel((ItemStack)itemStack, ItemEffect.mending) > 0).findAny().ifPresent(itemStack -> {
            int multiplier = this.getEffectLevel((ItemStack)itemStack, ItemEffect.mending) + 1;
            EntityXPOrb orb = event.getOrb();
            int durabilityGain = Math.min(orb.field_70530_e * multiplier, itemStack.func_77952_i());
            orb.field_70530_e -= durabilityGain / multiplier;
            itemStack.func_77964_b(itemStack.func_77952_i() - durabilityGain);
            if (orb.field_70530_e <= 0) {
                orb.field_70530_e = 0;
                player.field_71090_bL = 2;
                player.func_71001_a((Entity)orb, 1);
                orb.func_70106_y();
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Optional.ofNullable(event.getHarvester()).map(EntityLivingBase::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int fortuneLevel;
            IBlockState state = event.getState();
            if (!event.isSilkTouching() && (fortuneLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.fortune)) > 0) {
                event.getDrops().clear();
                List list = state.func_177230_c().getDrops((IBlockAccess)event.getWorld(), event.getPos(), state, fortuneLevel);
                event.getDrops().addAll(list);
            }
        });
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Optional.of(event.getItemStack()).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int critLevel;
            int strikingLevel = 0;
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            IBlockState blockState = world.func_180495_p(pos);
            String tool = ItemModularHandheld.getEffectiveTool(blockState);
            EntityPlayer breakingPlayer = event.getEntityPlayer();
            if (tool != null) {
                switch (tool) {
                    case "axe": {
                        strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingAxe);
                        break;
                    }
                    case "pickaxe": {
                        strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingPickaxe);
                        break;
                    }
                    case "cut": {
                        strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingCut);
                        break;
                    }
                    case "shovel": {
                        strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingShovel);
                    }
                }
            }
            if (strikingLevel > 0) {
                int sweepingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.sweepingStrike);
                if ((double)breakingPlayer.func_184825_o(0.0f) > 0.9) {
                    if (sweepingLevel > 0) {
                        this.breakBlocksAround(world, breakingPlayer, (ItemStack)itemStack, pos, tool, sweepingLevel);
                    } else {
                        int toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState);
                        if (toolLevel >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState)) {
                            world.func_180498_a(breakingPlayer, 2001, pos, Block.func_176210_f((IBlockState)blockState));
                            ItemEffectHandler.breakBlock(world, breakingPlayer, itemStack, pos, blockState);
                        }
                    }
                    itemStack.func_77972_a(2, (EntityLivingBase)breakingPlayer);
                }
                event.setCanceled(true);
                breakingPlayer.func_184821_cY();
            }
            if (!event.getWorld().field_72995_K && (critLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.criticalStrike)) > 0 && this.critBlock(world, breakingPlayer, pos, blockState, (ItemStack)itemStack, tool, critLevel)) {
                event.setCanceled(true);
            }
        });
    }

    private boolean critBlock(World world, EntityPlayer breakingPlayer, BlockPos pos, IBlockState blockState, ItemStack itemStack, String tool, int critLevel) {
        int toolLevel;
        if ((double)breakingPlayer.func_70681_au().nextFloat() < (double)critLevel * 0.01 && itemStack.func_77973_b().func_150893_a(itemStack, blockState) > 2.0f * blockState.func_185887_b(world, pos) && ((toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState)) >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState))) {
            world.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)blockState));
            ItemEffectHandler.breakBlock(world, breakingPlayer, itemStack, pos, blockState);
            itemStack.func_77972_a(2, (EntityLivingBase)breakingPlayer);
            ((ItemModular)itemStack.func_77973_b()).tickProgression((EntityLivingBase)breakingPlayer, itemStack, 1);
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.CRIT_MAGIC, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 12, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + world.field_73012_v.nextDouble() * 0.3, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3, new int[0]);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            World world = event.getEntity().func_130014_f_();
            AxisAlignedBB aabb = new AxisAlignedBB(event.getTargetX() - 24.0, event.getTargetY() - 24.0, event.getTargetZ() - 24.0, event.getTargetX() + 24.0, event.getTargetY() + 24.0, event.getTargetZ() + 24.0);
            event.getEntity().func_130014_f_().func_72872_a(EntityPlayer.class, aabb).forEach(player -> {
                double effectProbability;
                int reverbLevel = CapabilityHelper.getPlayerEffectLevel(player, ItemEffect.enderReverb);
                if (reverbLevel > 0 && (effectProbability = CapabilityHelper.getPlayerEffectEfficiency(player, ItemEffect.enderReverb)) > 0.0 && player.func_70681_au().nextDouble() < effectProbability * 2.0) {
                    player.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 40 * reverbLevel));
                }
            });
        }
    }

    public static boolean breakBlock(World world, EntityPlayer breakingPlayer, ItemStack toolStack, BlockPos pos, IBlockState blockState) {
        boolean canRemove = blockState.func_177230_c().removedByPlayer(blockState, world, pos, breakingPlayer, true);
        if (canRemove && !world.field_72995_K) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
            blockState.func_177230_c().func_180657_a(world, breakingPlayer, pos, blockState, world.func_175625_s(pos), toolStack);
        }
        return canRemove;
    }

    private void breakBlocksAround(World world, EntityPlayer breakingPlayer, ItemStack toolStack, BlockPos originPos, String tool, int sweepingLevel) {
        if (world.field_72995_K) {
            return;
        }
        EnumFacing facing = breakingPlayer.func_174811_aO();
        int strikeCounter = this.getStrikeCounter(breakingPlayer.func_110124_au());
        boolean alternate = strikeCounter % 2 == 0;
        ItemModularHandheld.spawnSweepParticles(world, originPos.func_177958_n(), (double)originPos.func_177956_o() + 0.5, originPos.func_177952_p(), 0.0, 0.0);
        Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(pos -> {
            if (alternate) {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return pos;
        }).map(pos -> this.rotatePos((BlockPos)pos, facing)).map(arg_0 -> ((BlockPos)originPos).func_177971_a(arg_0)).forEachOrdered(pos -> {
            int toolLevel;
            IBlockState blockState = world.func_180495_p(pos);
            if (tool.equals(ItemModularHandheld.getEffectiveTool(blockState)) && ((toolLevel = toolStack.func_77973_b().getHarvestLevel(toolStack, tool, breakingPlayer, blockState)) >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || toolStack.func_150998_b(blockState))) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
                ItemEffectHandler.breakBlock(world, breakingPlayer, toolStack, pos, blockState);
            }
        });
    }

    private int getStrikeCounter(UUID entityId) {
        int counter = 0;
        try {
            counter = (Integer)this.strikeCache.get((Object)entityId, () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.strikeCache.put((Object)entityId, (Object)(counter + 1));
        return counter;
    }

    private BlockPos rotatePos(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            default: {
                return pos;
            }
            case WEST: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case NORTH: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case EAST: 
        }
        return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowNock(ArrowNockEvent event) {
        ItemStack itemStack;
        if (!event.hasAmmo() && event.getEntityPlayer().func_184586_b(EnumHand.OFF_HAND).func_190926_b() && !(itemStack = UtilToolbelt.findToolbelt(event.getEntityPlayer())).func_190926_b()) {
            InventoryQuiver inventory = new InventoryQuiver(itemStack);
            List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!effects.get(i).contains((Object)ItemEffect.quickAccess) || inventory.func_70301_a(i).func_190926_b()) continue;
                event.getEntityPlayer().func_184611_a(EnumHand.OFF_HAND, inventory.func_70301_a(i).func_77979_a(1));
                event.getEntityPlayer().func_184598_c(event.getHand());
                inventory.func_70296_d();
                event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)event.getBow()));
                return;
            }
        }
    }

    static {
        sweep1 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-3, 0, -1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(3, 0, -1), new BlockPos(-3, 0, -2), new BlockPos(-2, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-2, 1, -1), new BlockPos(-1, 1, -1), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-1, -1, -1)};
        sweep2 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(3, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(2, 0, 1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(4, 0, -1), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(1, -1, 0)};
    }
}

