/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.schema.Material;
import se.mickelus.tetra.module.schema.RepairDefinition;

public abstract class ItemModule<T extends ModuleData>
implements ICapabilityProvider {
    protected T[] data;
    protected TweakData[] tweaks = new TweakData[0];
    protected String slotKey;
    protected String moduleKey;
    protected String dataKey;
    protected Priority renderLayer = Priority.BASE;

    public ItemModule(String slotKey, String moduleKey) {
        this.slotKey = slotKey;
        this.moduleKey = moduleKey;
        this.dataKey = moduleKey + "_material";
    }

    public ItemModule<T> withRenderLayer(Priority layer) {
        this.renderLayer = layer;
        return this;
    }

    public String getKey() {
        return this.moduleKey;
    }

    public String getUnlocalizedName() {
        return this.moduleKey;
    }

    public String getSlot() {
        return this.slotKey;
    }

    public void addModule(ItemStack targetStack, String variantKey, EntityPlayer player) {
        NBTTagCompound tag = NBTHelper.getTag(targetStack);
        tag.func_74778_a(this.slotKey, this.moduleKey);
        tag.func_74778_a(this.dataKey, variantKey);
    }

    public ItemStack[] removeModule(ItemStack targetStack) {
        NBTTagCompound tag = NBTHelper.getTag(targetStack);
        tag.func_82580_o(this.slotKey);
        tag.func_82580_o(this.dataKey);
        return new ItemStack[0];
    }

    public void postRemove(ItemStack targetStack, EntityPlayer player) {
    }

    public T getData(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        String dataName = tag.func_74779_i(this.dataKey);
        return this.getData(dataName);
    }

    public T getData(String variantKey) {
        return (T)Arrays.stream(this.data).filter(moduleData -> moduleData.key.equals(variantKey)).findAny().orElse((ModuleData)this.getDefaultData());
    }

    public T getDefaultData() {
        return this.data[0];
    }

    public String getName(ItemStack itemStack) {
        return I18n.func_135052_a((String)((ModuleData)this.getData((ItemStack)itemStack)).key, (Object[])new Object[0]);
    }

    public String getDescription(ItemStack itemStack) {
        String dataKey = ((ModuleData)this.getData((ItemStack)itemStack)).key;
        if (I18n.func_188566_a((String)(dataKey + ".description"))) {
            return I18n.func_135052_a((String)(dataKey + ".description"), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)(this.getUnlocalizedName() + ".description"), (Object[])new Object[0]);
    }

    public String getItemName(ItemStack itemStack) {
        String name = ((ModuleData)this.getData((ItemStack)itemStack)).key + ".item_name";
        if (I18n.func_188566_a((String)name)) {
            return I18n.func_135052_a((String)name, (Object[])new Object[0]);
        }
        if (I18n.func_188566_a((String)(this.getUnlocalizedName() + ".item_name"))) {
            return I18n.func_135052_a((String)(this.getUnlocalizedName() + ".item_name"), (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemNamePriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public String getItemPrefix(ItemStack itemStack) {
        String prefix = ((ModuleData)this.getData((ItemStack)itemStack)).key + ".prefix";
        if (I18n.func_188566_a((String)prefix)) {
            return I18n.func_135052_a((String)prefix, (Object[])new Object[0]);
        }
        if (I18n.func_188566_a((String)(this.getUnlocalizedName() + ".prefix"))) {
            return I18n.func_135052_a((String)(this.getUnlocalizedName() + ".prefix"), (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemPrefixPriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public int getIntegrityGain(ItemStack itemStack) {
        int integrity = ((ModuleData)this.getData((ItemStack)itemStack)).integrity;
        if (integrity > 0) {
            return integrity;
        }
        return 0;
    }

    public int getIntegrityCost(ItemStack itemStack) {
        int integrity = ((ModuleData)this.getData((ItemStack)itemStack)).integrity;
        if (integrity < 0) {
            return integrity;
        }
        return 0;
    }

    public int getMagicCapacity(ItemStack itemStack) {
        return this.getMagicCapacityGain(itemStack) - this.getMagicCapacityCost(itemStack);
    }

    public int getMagicCapacityGain(ItemStack itemStack) {
        int magicCapacity = ((ModuleData)this.getData((ItemStack)itemStack)).magicCapacity;
        if (magicCapacity > 0) {
            return magicCapacity;
        }
        return 0;
    }

    public int getMagicCapacityCost(ItemStack itemStack) {
        int magicCapacity = ((ModuleData)this.getData((ItemStack)itemStack)).magicCapacity;
        if (magicCapacity < 0) {
            return -magicCapacity;
        }
        return 0;
    }

    public int getDurability(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToInt(tweak -> tweak.getDurability(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + ((ModuleData)this.getData((ItemStack)itemStack)).durability;
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getDurabilityMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(((ModuleData)this.getData((ItemStack)itemStack)).durabilityMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public Material getRepairMaterial(ItemStack itemStack) {
        RepairDefinition definition = ItemUpgradeRegistry.instance.getRepairDefinition(((ModuleData)this.getData((ItemStack)itemStack)).key);
        if (definition != null) {
            return definition.material;
        }
        return null;
    }

    public int getRepairAmount(ItemStack itemStack) {
        return ((ModuleData)this.getData((ItemStack)itemStack)).durability;
    }

    public Collection<Capability> getRepairRequiredCapabilities(ItemStack itemStack) {
        RepairDefinition definition = ItemUpgradeRegistry.instance.getRepairDefinition(((ModuleData)this.getData((ItemStack)itemStack)).key);
        if (definition != null) {
            return definition.requiredCapabilities.getValues();
        }
        return Collections.emptyList();
    }

    public int getRepairRequiredCapabilityLevel(ItemStack itemStack, Capability capability) {
        RepairDefinition definition = ItemUpgradeRegistry.instance.getRepairDefinition(((ModuleData)this.getData((ItemStack)itemStack)).key);
        if (definition != null) {
            return definition.requiredCapabilities.getLevel(capability);
        }
        return 0;
    }

    public boolean isTweakable(ItemStack itemStack) {
        String variant = NBTHelper.getTag(itemStack).func_74779_i(this.dataKey);
        return Arrays.stream(this.tweaks).anyMatch(data -> variant.equals(data.variant));
    }

    public TweakData[] getTweaks(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        String variant = tag.func_74779_i(this.dataKey);
        return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant)).toArray(TweakData[]::new);
    }

    public boolean hasTweak(ItemStack itemStack, String tweakKey) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.key).anyMatch(tweakKey::equals);
    }

    public int getTweakStep(ItemStack itemStack, TweakData tweak) {
        return Math.max(Math.min(NBTHelper.getTag(itemStack).func_74762_e(this.slotKey + ":" + tweak.key), tweak.steps), -tweak.steps);
    }

    public void setTweakStep(ItemStack itemStack, String tweakKey, int step) {
        NBTHelper.getTag(itemStack).func_74768_a(this.slotKey + ":" + tweakKey, step);
    }

    public double getDamageModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getDamage(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + (double)((ModuleData)this.getData((ItemStack)itemStack)).damage;
    }

    public double getDamageMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getDamageMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(((ModuleData)this.getData((ItemStack)itemStack)).damageMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public double getSpeedModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getAttackSpeed(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + (double)((ModuleData)this.getData((ItemStack)itemStack)).attackSpeed;
    }

    public double getSpeedMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getAttackSpeedMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(((ModuleData)this.getData((ItemStack)itemStack)).attackSpeedMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public ResourceLocation[] getTextures(ItemStack itemStack) {
        return new ResourceLocation[]{((ModuleData)this.getData(itemStack)).getTextureLocation()};
    }

    public Priority getRenderLayer() {
        return this.renderLayer;
    }

    public ResourceLocation[] getAllTextures() {
        return (ResourceLocation[])Arrays.stream(this.data).map(ModuleData::getTextureLocation).toArray(ResourceLocation[]::new);
    }

    public void hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return ((ModuleData)this.getData((ItemStack)itemStack)).effects.getLevel(effect);
    }

    public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return (float)Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getEffectEfficiency(effect, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + ((ModuleData)this.getData((ItemStack)itemStack)).effects.getEfficiency(effect);
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        return ((ModuleData)this.getData((ItemStack)itemStack)).effects.getValues();
    }

    @Override
    public int getCapabilityLevel(ItemStack itemStack, Capability capability) {
        return ((ModuleData)this.getData((ItemStack)itemStack)).capabilities.getLevel(capability);
    }

    @Override
    public float getCapabilityEfficiency(ItemStack itemStack, Capability capability) {
        return (float)Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getCapabilityEfficiency(capability, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + ((ModuleData)this.getData((ItemStack)itemStack)).capabilities.getEfficiency(capability);
    }

    @Override
    public Collection<Capability> getCapabilities(ItemStack itemStack) {
        return ((ModuleData)this.getData((ItemStack)itemStack)).capabilities.getValues();
    }
}

