/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.CastOptional;

public abstract class ItemModuleMajor<T extends ModuleData>
extends ItemModule<T> {
    protected ImprovementData[] improvements = new ImprovementData[0];
    public static final String settleImprovement = "settled";
    public static final String arrestedImprovement = "arrested";
    protected int settleMax = 0;
    private String settleProgressKey = this.getSlot() + this.settleProgressKey;

    public ItemModuleMajor(String slotKey, String moduleKey) {
        super(slotKey, moduleKey);
    }

    public void tickProgression(EntityLivingBase entity, ItemStack itemStack, int multiplier) {
        int settleMaxCount = this.getSettleMaxCount(itemStack);
        if (settleMaxCount == 0) {
            return;
        }
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        int settleLevel = this.getImprovementLevel(itemStack, settleImprovement);
        if (settleLevel < settleMaxCount && this.getImprovementLevel(itemStack, arrestedImprovement) == -1) {
            int settleProgress = this.getSettleProgress(itemStack);
            tag.func_74768_a(this.settleProgressKey, settleProgress -= multiplier);
            if (settleProgress <= 0) {
                this.addImprovement(itemStack, settleImprovement, settleLevel == -1 ? 1 : settleLevel + 1);
                tag.func_82580_o(this.settleProgressKey);
                if (entity instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                    PacketHandler.sendTo(new SettlePacket(itemStack, this.getSlot()), (EntityPlayerMP)entity);
                }
            }
        }
    }

    public int getSettleProgress(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        if (tag.func_74764_b(this.settleProgressKey)) {
            return tag.func_74762_e(this.settleProgressKey);
        }
        return this.getSettleLimit(itemStack);
    }

    public int getSettleLimit(ItemStack itemStack) {
        return (int)(((float)ConfigHandler.settleLimitBase + (float)this.getDurability(itemStack) * ConfigHandler.settleLimitDurabilityMultiplier) * Math.max((float)this.getImprovementLevel(itemStack, settleImprovement) * ConfigHandler.settleLimitLevelMultiplier, 1.0f));
    }

    public int getSettleMaxCount(ItemStack itemStack) {
        if (this.settleMax == 0) {
            return 0;
        }
        int integrity = ((ModuleData)this.getData((ItemStack)itemStack)).integrity;
        if (integrity <= -4 || integrity >= 6) {
            return this.settleMax;
        }
        if (integrity != 0) {
            return 1;
        }
        return 0;
    }

    protected void clearProgression(ItemStack itemStack) {
        NBTHelper.getTag(itemStack).func_82580_o(String.format(this.settleProgressKey, this.getSlot()));
    }

    public int getImprovementLevel(ItemStack itemStack, String improvementKey) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        if (tag.func_74764_b(this.slotKey + ":" + improvementKey)) {
            return tag.func_74762_e(this.slotKey + ":" + improvementKey);
        }
        return -1;
    }

    public ImprovementData getImprovement(ItemStack itemStack, String improvementKey) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        return Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).filter(improvement -> tag.func_74764_b(this.slotKey + ":" + improvement.key)).filter(improvement -> improvement.level == tag.func_74762_e(this.slotKey + ":" + improvement.key)).findAny().orElse(null);
    }

    public ImprovementData[] getImprovements(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        return (ImprovementData[])Arrays.stream(this.improvements).filter(improvement -> tag.func_74764_b(this.slotKey + ":" + improvement.key)).filter(improvement -> improvement.level == tag.func_74762_e(this.slotKey + ":" + improvement.key)).toArray(ImprovementData[]::new);
    }

    public boolean acceptsImprovement(String improvementKey) {
        return Arrays.stream(this.improvements).map(improvement -> improvement.key).anyMatch(improvementKey::equals);
    }

    public boolean acceptsImprovementLevel(String improvementKey, int level) {
        return Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).anyMatch(improvement -> level == improvement.level);
    }

    public void addImprovement(ItemStack itemStack, String improvementKey, int level) {
        this.removeCollidingImprovements(itemStack, improvementKey, level);
        NBTHelper.getTag(itemStack).func_74768_a(this.slotKey + ":" + improvementKey, level);
    }

    public static void addImprovement(ItemStack itemStack, String slot, String improvement, int level) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        CastOptional.cast(item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).ifPresent(module -> module.addImprovement(itemStack, improvement, level));
    }

    public void removeCollidingImprovements(ItemStack itemStack, String improvementKey, int level) {
        Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).filter(improvement -> level == improvement.level).filter(improvement -> improvement.group != null).map(improvement -> improvement.group).findFirst().ifPresent(group -> Arrays.stream(this.getImprovements(itemStack)).filter(improvement -> group.equals(improvement.group)).forEach(improvement -> ItemModuleMajor.removeImprovement(itemStack, this.slotKey, improvement.key)));
    }

    public void removeImprovement(ItemStack itemStack, String improvement) {
        ItemModuleMajor.removeImprovement(itemStack, this.slotKey, improvement);
    }

    public static void removeImprovement(ItemStack itemStack, String slot, String improvement) {
        NBTHelper.getTag(itemStack).func_82580_o(slot + ":" + improvement);
    }

    @Override
    public TweakData[] getTweaks(ItemStack itemStack) {
        NBTTagCompound tag = NBTHelper.getTag(itemStack);
        String variant = tag.func_74779_i(this.dataKey);
        String[] improvementKeys = (String[])Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key).toArray(String[]::new);
        return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant) || ArrayUtils.contains((Object[])improvementKeys, (Object)tweak.improvement)).toArray(TweakData[]::new);
    }

    @Override
    public ItemStack[] removeModule(ItemStack targetStack) {
        ItemStack[] salvage = super.removeModule(targetStack);
        NBTTagCompound tag = NBTHelper.getTag(targetStack);
        Arrays.stream(this.improvements).map(improvement -> this.slotKey + ":" + improvement.key).forEach(arg_0 -> ((NBTTagCompound)tag).func_82580_o(arg_0));
        this.clearProgression(targetStack);
        return salvage;
    }

    @Override
    public double getDamageModifier(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToDouble(improvement -> improvement.damage).sum() + super.getDamageModifier(itemStack);
    }

    @Override
    public double getDamageMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> Float.valueOf(improvement.damageMultiplier)).reduce(Float.valueOf((float)super.getDamageMultiplierModifier(itemStack)), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    @Override
    public double getSpeedModifier(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToDouble(improvement -> improvement.attackSpeed).sum() + super.getSpeedModifier(itemStack);
    }

    @Override
    public double getSpeedMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> Float.valueOf(improvement.attackSpeedMultiplier)).reduce(Float.valueOf((float)super.getSpeedMultiplierModifier(itemStack)), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    @Override
    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.effects).mapToInt(effects -> effects.getLevel(effect)).sum() + super.getEffectLevel(itemStack, effect);
    }

    @Override
    public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return (float)Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.effects).mapToDouble(effects -> effects.getEfficiency(effect)).sum() + (float)super.getEffectLevel(itemStack, effect);
    }

    @Override
    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        return Streams.concat((Stream[])new Stream[]{super.getEffects(itemStack).stream(), Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.effects).flatMap(effects -> effects.getValues().stream())}).distinct().collect(Collectors.toSet());
    }

    @Override
    public int getCapabilityLevel(ItemStack itemStack, Capability capability) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvementData -> improvementData.capabilities).mapToInt(capabilityData -> capabilityData.getLevel(capability)).sum() + super.getCapabilityLevel(itemStack, capability);
    }

    @Override
    public float getCapabilityEfficiency(ItemStack itemStack, Capability capability) {
        return (float)Arrays.stream(this.getImprovements(itemStack)).map(improvementData -> improvementData.capabilities).mapToDouble(capabilityData -> capabilityData.getEfficiency(capability)).sum() + super.getCapabilityEfficiency(itemStack, capability);
    }

    @Override
    public Collection<Capability> getCapabilities(ItemStack itemStack) {
        return Streams.concat((Stream[])new Stream[]{super.getCapabilities(itemStack).stream(), Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.capabilities).flatMap(capabilities -> capabilities.getValues().stream())}).distinct().collect(Collectors.toSet());
    }

    @Override
    public int getIntegrityGain(ItemStack itemStack) {
        return super.getIntegrityGain(itemStack) + this.getImprovementIntegrityGain(itemStack);
    }

    @Override
    public int getIntegrityCost(ItemStack itemStack) {
        return super.getIntegrityCost(itemStack) + this.getImprovementIntegrityCost(itemStack);
    }

    private int getImprovementIntegrityGain(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.integrity).filter(integrity -> integrity > 0).sum();
    }

    private int getImprovementIntegrityCost(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.integrity).filter(integrity -> integrity < 0).sum();
    }

    @Override
    public int getMagicCapacityGain(ItemStack itemStack) {
        return super.getMagicCapacityGain(itemStack) + this.getImprovementMagicCapacityGain(itemStack);
    }

    @Override
    public int getMagicCapacityCost(ItemStack itemStack) {
        return super.getMagicCapacityCost(itemStack) + this.getImprovementMagicCapacityCost(itemStack);
    }

    private int getImprovementMagicCapacityGain(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.magicCapacity).filter(magicCapacity -> magicCapacity > 0).sum();
    }

    private int getImprovementMagicCapacityCost(ItemStack itemStack) {
        return -Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.magicCapacity).filter(integrity -> integrity < 0).sum();
    }

    @Override
    public int getDurability(ItemStack itemStack) {
        return (int)((double)(super.getDurability(itemStack) + this.getImprovementDurability(itemStack)) * this.getImprovementDurabilityMultiplier(itemStack));
    }

    private int getImprovementDurability(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.durability).sum();
    }

    private double getImprovementDurabilityMultiplier(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).mapToDouble(improvement -> improvement.durabilityMultiplier).filter(integrity -> integrity > 0.0).reduce(1.0, (a, b) -> a * b);
    }

    protected ResourceLocation[] getAllImprovementTextures() {
        return (ResourceLocation[])Arrays.stream(this.improvements).filter(improvement -> improvement.textured).map(improvement -> "items/" + improvement.key).map(resourceString -> new ResourceLocation("tetra", resourceString)).toArray(ResourceLocation[]::new);
    }

    @Override
    public ResourceLocation[] getAllTextures() {
        return (ResourceLocation[])ArrayUtils.addAll((Object[])super.getAllTextures(), (Object[])this.getAllImprovementTextures());
    }

    protected ResourceLocation[] getImprovementTextures(ItemStack itemStack) {
        return (ResourceLocation[])Arrays.stream(this.getImprovements(itemStack)).filter(improvement -> improvement.textured).map(improvement -> "items/" + improvement.key).map(resourceString -> new ResourceLocation("tetra", resourceString)).toArray(ResourceLocation[]::new);
    }

    @Override
    public ResourceLocation[] getTextures(ItemStack itemStack) {
        return (ResourceLocation[])ArrayUtils.addAll((Object[])super.getTextures(itemStack), (Object[])this.getImprovementTextures(itemStack));
    }
}

