/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.ItemPredicateModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.schema.BaseSchema;
import se.mickelus.tetra.module.schema.InvalidSchemaException;
import se.mickelus.tetra.module.schema.OutcomeDefinition;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaDefinition;
import se.mickelus.tetra.module.schema.SchemaRarity;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.Filter;

public class ConfigSchema
extends BaseSchema {
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot";
    private SchemaDefinition definition;
    private String keySuffix;
    private String moduleSlot;

    public ConfigSchema(SchemaDefinition definition) throws InvalidSchemaException {
        this(definition, "", null);
    }

    public ConfigSchema(SchemaDefinition definition, String keySuffix, String moduleSlot) throws InvalidSchemaException {
        this.definition = definition;
        this.keySuffix = keySuffix;
        this.moduleSlot = moduleSlot;
        String[] faultyModuleOutcomes = (String[])Arrays.stream(definition.outcomes).map(this::getModuleKey).filter(Objects::nonNull).filter(moduleKey -> ItemUpgradeRegistry.instance.getModule((String)moduleKey) == null).toArray(String[]::new);
        if (faultyModuleOutcomes.length != 0) {
            throw new InvalidSchemaException(definition.key, faultyModuleOutcomes);
        }
    }

    private String getModuleKey(OutcomeDefinition outcome) {
        if (outcome.moduleKey != null) {
            return outcome.moduleKey + this.keySuffix;
        }
        return null;
    }

    private Optional<OutcomeDefinition> getOutcomeFromMaterial(ItemStack materialStack, int slot) {
        return Arrays.stream(this.definition.outcomes).filter(outcome -> outcome.materialSlot == slot).filter(outcome -> outcome.material.predicate != null && outcome.material.predicate.func_192493_a(materialStack)).findAny();
    }

    @Override
    public String getKey() {
        return this.definition.key + this.keySuffix;
    }

    @Override
    public String getName() {
        if (this.definition.localizationKey != null) {
            return I18n.func_135052_a((String)(this.definition.localizationKey + nameSuffix), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)(this.definition.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        if (this.definition.localizationKey != null) {
            return I18n.func_135052_a((String)(this.definition.localizationKey + descriptionSuffix), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)(this.definition.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return this.definition.materialSlotCount;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        if (this.definition.localizationKey != null) {
            return I18n.func_135052_a((String)(this.definition.localizationKey + slotSuffix + (index + 1)), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)(this.definition.key + slotSuffix + (index + 1)), (Object[])new Object[0]);
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return this.getOutcomeFromMaterial(materialStack, index).map(outcome -> outcome.material.count).orElse(0);
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, int index, ItemStack materialStack) {
        return this.getOutcomeFromMaterial(materialStack, index).isPresent();
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, ItemStack[] materials) {
        if (this.getNumMaterialSlots() == 0) {
            return true;
        }
        if (materials.length < this.definition.materialSlotCount) {
            return false;
        }
        for (int i = 0; i < this.definition.materialSlotCount; ++i) {
            if (this.acceptsMaterial(itemStack, i, materials[i]) && materials[i].func_190916_E() >= this.getOutcomeFromMaterial(materials[i], i).map(outcome -> outcome.material.count).orElse(0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        if (!(!this.definition.hone || ConfigHandler.moduleProgression && ItemModular.isHoneable(itemStack))) {
            return false;
        }
        if (this.definition.requirement instanceof ItemPredicateModular) {
            return ((ItemPredicateModular)this.definition.requirement).test(itemStack, this.moduleSlot);
        }
        return this.definition.requirement.func_192493_a(itemStack);
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        if (this.moduleSlot != null) {
            return this.moduleSlot.equals(slot);
        }
        return Arrays.stream(this.definition.slots).anyMatch(s -> s.equals(slot));
    }

    @Override
    public boolean isVisibleForPlayer(EntityPlayer player, ItemStack targetStack) {
        if (this.definition.materialRevealSlot > -1) {
            for (int x = 0; x < 9; ++x) {
                for (int y = 0; y < 4; ++y) {
                    if (!this.acceptsMaterial(targetStack, this.definition.materialRevealSlot, player.field_71071_by.func_70301_a(y * 9 + x))) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isHoning() {
        return this.definition.hone;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        if (this.definition.materialSlotCount > 0) {
            return IntStream.range(0, materials.length).mapToObj(index -> this.getOutcomeFromMaterial(materials[index], index)).filter(Optional::isPresent).map(Optional::get).flatMap(outcome -> outcome.requiredCapabilities.getValues().stream()).distinct().collect(Collectors.toSet());
        }
        return Arrays.stream(this.definition.outcomes).findFirst().map(outcome -> outcome.requiredCapabilities.getValues()).orElseGet(HashSet::new);
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        if (this.definition.materialSlotCount > 0) {
            return IntStream.range(0, materials.length).mapToObj(index -> this.getOutcomeFromMaterial(materials[index], index)).filter(Optional::isPresent).map(Optional::get).map(outcome -> outcome.requiredCapabilities).filter(capabilities -> capabilities.contains(capability)).map(capabilities -> capabilities.getLevel(capability)).sorted().findFirst().orElse(0);
        }
        return Arrays.stream(this.definition.outcomes).findFirst().map(outcome -> outcome.requiredCapabilities).filter(capabilities -> capabilities.contains(capability)).map(capabilities -> capabilities.getLevel(capability)).orElse(0);
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, EntityPlayer player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        float durabilityFactor = 0.0f;
        if (consumeMaterials && upgradedStack.func_77984_f()) {
            durabilityFactor = (float)upgradedStack.func_77952_i() * 1.0f / (float)upgradedStack.func_77958_k();
        }
        float honingFactor = CastOptional.cast(upgradedStack.func_77973_b(), ItemModular.class).map(item -> Float.valueOf(1.0f * (float)item.getHoningProgress(upgradedStack) / (float)item.getHoningBase(upgradedStack))).map(factor -> Float.valueOf(Math.min(Math.max(factor.floatValue(), 0.0f), 1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
        if (this.definition.materialSlotCount > 0) {
            int i = 0;
            while (i < materials.length) {
                int index = i++;
                Optional<OutcomeDefinition> outcomeOptional = this.getOutcomeFromMaterial(materials[index], index);
                outcomeOptional.ifPresent(outcome -> {
                    this.applyOutcome((OutcomeDefinition)outcome, upgradedStack, consumeMaterials, slot, player);
                    if (consumeMaterials) {
                        materials[index].func_190918_g(outcome.material.count);
                        this.triggerAdvancement((OutcomeDefinition)outcome, player, itemStack, upgradedStack, slot);
                    }
                });
            }
        } else {
            for (OutcomeDefinition outcome2 : this.definition.outcomes) {
                this.applyOutcome(outcome2, upgradedStack, consumeMaterials, slot, player);
                if (!consumeMaterials) continue;
                this.triggerAdvancement(outcome2, player, itemStack, upgradedStack, slot);
            }
        }
        if (consumeMaterials) {
            if (this.definition.hone) {
                ItemModular.removeHoneable(upgradedStack);
            } else if (ConfigHandler.moduleProgression && !ItemModular.isHoneable(upgradedStack)) {
                CastOptional.cast(upgradedStack.func_77973_b(), ItemModular.class).ifPresent(item -> item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (float)item.getHoningBase(upgradedStack))));
            }
            if (upgradedStack.func_77984_f()) {
                upgradedStack.func_77964_b((int)(durabilityFactor * (float)upgradedStack.func_77958_k()));
            }
        }
        return upgradedStack;
    }

    private void applyOutcome(OutcomeDefinition outcome, ItemStack upgradedStack, boolean consumeMaterials, String slot, EntityPlayer player) {
        if (outcome.moduleKey != null) {
            ItemModule module = ItemUpgradeRegistry.instance.getModule(this.getModuleKey(outcome));
            ItemModule previousModule = this.removePreviousModule(upgradedStack, module.getSlot());
            module.addModule(upgradedStack, outcome.moduleVariant, player);
            outcome.improvements.forEach((key, value) -> ItemModuleMajor.addImprovement(upgradedStack, slot, key, value));
            if (previousModule != null && consumeMaterials) {
                previousModule.postRemove(upgradedStack, player);
            }
        } else {
            outcome.improvements.forEach((key, value) -> ItemModuleMajor.addImprovement(upgradedStack, slot, key, value));
        }
    }

    private void triggerAdvancement(OutcomeDefinition outcome, EntityPlayer player, ItemStack itemStack, ItemStack upgradedStack, String slot) {
        if (player instanceof EntityPlayerMP) {
            if (outcome.moduleKey != null) {
                if (outcome.requiredCapabilities.getValues().isEmpty()) {
                    ModuleCraftCriterion.trigger((EntityPlayerMP)player, itemStack, upgradedStack, this.getKey(), slot, outcome.moduleKey, outcome.moduleVariant, null, -1);
                } else {
                    outcome.requiredCapabilities.valueMap.forEach((capability, capabilityLevel) -> ModuleCraftCriterion.trigger((EntityPlayerMP)player, itemStack, upgradedStack, this.getKey(), slot, outcome.moduleKey, outcome.moduleVariant, capability, capabilityLevel));
                }
            }
            outcome.improvements.forEach((improvement, level) -> {
                if (outcome.requiredCapabilities.getValues().isEmpty()) {
                    ImprovementCraftCriterion.trigger((EntityPlayerMP)player, itemStack, upgradedStack, this.getKey(), slot, improvement, level, null, -1);
                } else {
                    outcome.requiredCapabilities.valueMap.forEach((capability, capabilityLevel) -> ImprovementCraftCriterion.trigger((EntityPlayerMP)player, itemStack, upgradedStack, this.getKey(), slot, improvement, level, capability, capabilityLevel));
                }
            });
        }
    }

    protected ItemModule removePreviousModule(ItemStack itemStack, String slot) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        ItemModule previousModule = item.getModuleFromSlot(itemStack, slot);
        if (previousModule != null) {
            previousModule.removeModule(itemStack);
        }
        return previousModule;
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        int cost = 0;
        if (this.definition.materialSlotCount > 0) {
            for (int i = 0; i < materials.length; ++i) {
                cost += this.getOutcomeFromMaterial(materials[i], i).map(outcome -> outcome.experienceCost).orElse(0).intValue();
            }
        } else {
            cost += Arrays.stream(this.definition.outcomes).mapToInt(outcome -> outcome.experienceCost).sum();
        }
        return cost;
    }

    @Override
    public SchemaType getType() {
        return this.definition.displayType;
    }

    @Override
    public SchemaRarity getRarity() {
        return this.definition.rarity;
    }

    @Override
    public GlyphData getGlyph() {
        return this.definition.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        return (OutcomePreview[])Arrays.stream(this.definition.outcomes).map(outcome -> {
            GlyphData glyph;
            Object module;
            String key = null;
            if (outcome.moduleKey != null) {
                module = ItemUpgradeRegistry.instance.getModule(this.getModuleKey((OutcomeDefinition)outcome));
                key = outcome.moduleVariant;
                glyph = ((ModuleData)((ItemModule)module).getData((String)outcome.moduleVariant)).glyph;
            } else if (outcome.improvements.size() == 1) {
                module = outcome.improvements.keySet().iterator();
                while (module.hasNext()) {
                    String improvementKey;
                    key = improvementKey = (String)module.next();
                }
                glyph = this.definition.glyph;
            } else if (!outcome.improvements.isEmpty()) {
                key = this.definition.key;
                glyph = this.definition.glyph;
            } else {
                return null;
            }
            ItemStack itemStack = targetStack.func_77946_l();
            this.applyOutcome((OutcomeDefinition)outcome, itemStack, false, slot, null);
            return new OutcomePreview(key, glyph, itemStack, this.definition.displayType, outcome.requiredCapabilities, outcome.material.getApplicableItemstacks());
        }).filter(Filter.distinct(preview -> preview.key)).toArray(OutcomePreview[]::new);
    }
}

