/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class Material {
    public ItemPredicate predicate;
    public int count = 1;
    private ItemStack itemStack;
    private String ore;

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        NonNullList itemStacks;
        if (this.itemStack != null) {
            return this.itemStack.func_82833_r();
        }
        if (this.ore != null && !(itemStacks = OreDictionary.getOres((String)this.ore)).isEmpty()) {
            return ((ItemStack)itemStacks.get(0)).func_82833_r();
        }
        return "Unknown material";
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack[] getApplicableItemstacks() {
        if (this.itemStack != null && !this.itemStack.func_190926_b()) {
            return new ItemStack[]{this.itemStack};
        }
        if (this.ore != null) {
            NonNullList itemStacks = OreDictionary.getOres((String)this.ore);
            itemStacks.forEach(stack -> stack.func_190920_e(this.count));
            itemStacks.stream().filter(stack -> stack.func_77952_i() == Short.MAX_VALUE).forEach(stack -> stack.func_77964_b(0));
            return (ItemStack[])itemStacks.toArray((Object[])new ItemStack[0]);
        }
        return new ItemStack[0];
    }

    public static class MaterialDeserializer
    implements JsonDeserializer<Material> {
        public Material deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Material material = new Material();
            if (element != null && !element.isJsonNull()) {
                JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)element, (String)"material");
                String type = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"type", (String)"");
                material.count = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"count", (int)1);
                jsonObject.remove("count");
                if (jsonObject.has("item")) {
                    ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"item"));
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourcelocation);
                    int data = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"data", (int)0);
                    material.itemStack = new ItemStack(item, material.count, data);
                } else if ("forge:ore_dict".equals(type) && jsonObject.has("ore")) {
                    material.ore = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"ore");
                }
                try {
                    material.predicate = ItemPredicate.func_192492_a((JsonElement)element);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            return material;
        }
    }
}

