/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.BaseSchema;
import se.mickelus.tetra.module.schema.SchemaType;

public class RemoveSchema
extends BaseSchema {
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private String key = "remove_schema";
    private ItemModular item;
    private String slot;
    private GlyphData glyph = new GlyphData("textures/gui/workbench.png", 52, 32);

    public RemoveSchema(ItemModular item, String slot) {
        this.item = item;
        this.slot = slot;
        ItemUpgradeRegistry.instance.registerSchema(this);
    }

    public static void registerRemoveSchemas(ItemModular item) {
        Stream.concat(Arrays.stream(item.getMajorModuleKeys()), Arrays.stream(item.getMinorModuleKeys())).filter(slot -> !item.isModuleRequired((String)slot)).forEach(slot -> new RemoveSchema(item, (String)slot));
    }

    @Override
    public String getKey() {
        return this.key + "/" + this.item.func_77658_a() + "/" + this.slot;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)(this.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 0;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return "";
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, int index, ItemStack materialStack) {
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.slot.equals(slot) && this.item.getModuleFromSlot(targetStack, this.slot) != null;
    }

    @Override
    public boolean canApplyUpgrade(EntityPlayer player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return !this.isIntegrityViolation(player, itemStack, materials, slot) && this.checkCapabilities(itemStack, materials, availableCapabilities);
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, ItemStack[] materials) {
        return true;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, EntityPlayer player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        float durabilityFactor = 0.0f;
        if (consumeMaterials && upgradedStack.func_77984_f()) {
            durabilityFactor = (float)upgradedStack.func_77952_i() * 1.0f / (float)upgradedStack.func_77958_k();
        }
        float honingFactor = Math.min(Math.max(1.0f * (float)item.getHoningProgress(upgradedStack) / (float)item.getHoningBase(upgradedStack), 0.0f), 1.0f);
        ItemModule previousModule = item.getModuleFromSlot(upgradedStack, slot);
        if (previousModule != null) {
            previousModule.removeModule(upgradedStack);
            if (consumeMaterials) {
                previousModule.postRemove(upgradedStack, player);
            }
        }
        if (consumeMaterials) {
            if (ConfigHandler.moduleProgression && ItemModular.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (float)item.getHoningBase(upgradedStack)));
            }
            if (upgradedStack.func_77984_f()) {
                upgradedStack.func_77964_b((int)(durabilityFactor * (float)upgradedStack.func_77958_k()));
            }
        }
        return upgradedStack;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        ItemModule module;
        if (targetStack.func_77973_b() instanceof ItemModular && (module = this.item.getModuleFromSlot(targetStack, this.slot)) != null) {
            return module.getRepairRequiredCapabilities(targetStack);
        }
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        ItemModule module;
        if (targetStack.func_77973_b() instanceof ItemModular && (module = this.item.getModuleFromSlot(targetStack, this.slot)) != null) {
            return module.getRepairRequiredCapabilityLevel(targetStack, capability);
        }
        return 0;
    }

    @Override
    public SchemaType getType() {
        return SchemaType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

