/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaRarity;
import se.mickelus.tetra.module.schema.SchemaType;

public interface UpgradeSchema {
    public String getKey();

    public String getName();

    public String getDescription(@Nullable ItemStack var1);

    public int getNumMaterialSlots();

    public String getSlotName(ItemStack var1, int var2);

    public int getRequiredQuantity(ItemStack var1, int var2, ItemStack var3);

    public boolean acceptsMaterial(ItemStack var1, int var2, ItemStack var3);

    public boolean isMaterialsValid(ItemStack var1, ItemStack[] var2);

    public boolean isApplicableForItem(ItemStack var1);

    public boolean isApplicableForSlot(String var1, ItemStack var2);

    default public boolean isVisibleForPlayer(EntityPlayer player, ItemStack targetStack) {
        return true;
    }

    public boolean canApplyUpgrade(EntityPlayer var1, ItemStack var2, ItemStack[] var3, String var4, int[] var5);

    public boolean isIntegrityViolation(EntityPlayer var1, ItemStack var2, ItemStack[] var3, String var4);

    public ItemStack applyUpgrade(ItemStack var1, ItemStack[] var2, boolean var3, String var4, EntityPlayer var5);

    public boolean checkCapabilities(ItemStack var1, ItemStack[] var2, int[] var3);

    public Collection<Capability> getRequiredCapabilities(ItemStack var1, ItemStack[] var2);

    public int getRequiredCapabilityLevel(ItemStack var1, ItemStack[] var2, Capability var3);

    default public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        return 0;
    }

    default public boolean isHoning() {
        return false;
    }

    public SchemaType getType();

    default public SchemaRarity getRarity() {
        return SchemaRarity.basic;
    }

    public GlyphData getGlyph();

    public OutcomePreview[] getPreviews(ItemStack var1, String var2);
}

