/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.network;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.TetraLogger;
import se.mickelus.tetra.network.AbstractPacket;

public class PacketHandler
implements IMessageHandler<AbstractPacket, AbstractPacket> {
    public static final SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel("tetra");
    private ArrayList<Class<? extends AbstractPacket>> packets = new ArrayList();
    public static PacketHandler instance;

    public PacketHandler() {
        instance = this;
    }

    public boolean registerPacket(Class<? extends AbstractPacket> packetClass, Side side) {
        if (this.packets.size() > 256) {
            TetraLogger.log("Attempted to register packet but packet list is full: " + packetClass.toString());
            return false;
        }
        if (this.packets.contains(packetClass)) {
            TetraLogger.log("Attempted to register packet but packet is already in list: " + packetClass.toString());
            return false;
        }
        channel.registerMessage((IMessageHandler)this, packetClass, (int)((byte)this.packets.size()), side);
        this.packets.add(packetClass);
        return true;
    }

    public AbstractPacket onMessage(AbstractPacket message, MessageContext ctx) {
        if (ctx.side.equals((Object)Side.CLIENT)) {
            this.onMessageClient(message);
        } else {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> message.handle((EntityPlayer)player));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void onMessageClient(AbstractPacket message) {
        Minecraft.func_71410_x().func_152344_a(() -> message.handle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public static void sendToAll(AbstractPacket message) {
        channel.sendToAll((IMessage)message);
    }

    public static void sendTo(AbstractPacket message, EntityPlayerMP player) {
        channel.sendTo((IMessage)message, player);
    }

    public static void sendToAllAround(AbstractPacket message, NetworkRegistry.TargetPoint point) {
        channel.sendToAllAround((IMessage)message, point);
    }

    public static void sendToDimension(AbstractPacket message, int dimensionId) {
        channel.sendToDimension((IMessage)message, dimensionId);
    }

    public static void sendToServer(AbstractPacket message) {
        channel.sendToServer((IMessage)message);
    }
}

