/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class RotationHelper {
    public static Rotation rotationFromFacing(Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos rotatePitch(BlockPos pos, float pitch) {
        float f = MathHelper.func_76134_b((float)pitch);
        float f1 = MathHelper.func_76126_a((float)pitch);
        float x = pos.func_177958_n();
        float y = (float)pos.func_177956_o() * f + (float)pos.func_177952_p() * f1;
        float z = (float)pos.func_177952_p() * f - (float)pos.func_177956_o() * f1;
        return new BlockPos(Math.round(x), Math.round(y), Math.round(z));
    }

    public static BlockPos rotateYaw(BlockPos pos, float yaw) {
        float f = MathHelper.func_76134_b((float)yaw);
        float f1 = MathHelper.func_76126_a((float)yaw);
        double x = (double)pos.func_177958_n() * (double)f + (double)pos.func_177952_p() * (double)f1;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() * (double)f - (double)pos.func_177958_n() * (double)f1;
        return new BlockPos(x, y, z);
    }

    public static BlockPos rotateCardinal(BlockPos pos, Direction facing) {
        switch (facing) {
            default: {
                return pos;
            }
            case WEST: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case NORTH: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case EAST: 
        }
        return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
    }
}

