/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.advancements;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;

public class GenericTrigger<T extends ICriterionInstance>
implements ICriterionTrigger<T> {
    private ResourceLocation id;
    private Map<PlayerAdvancements, Set<ICriterionTrigger.Listener<T>>> listeners;
    private Function<JsonObject, T> deserializer;

    public GenericTrigger(String id, Function<JsonObject, T> deserializer) {
        this.id = new ResourceLocation(id);
        this.listeners = Maps.newHashMap();
        this.deserializer = deserializer;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements advancements, ICriterionTrigger.Listener<T> listener) {
        this.listeners.computeIfAbsent(advancements, key -> Sets.newHashSet()).add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener<T> listener) {
        Optional.ofNullable(this.listeners.get(advancements)).ifPresent(advancementListeners -> {
            advancementListeners.remove(listener);
            if (advancementListeners.isEmpty()) {
                this.listeners.remove(advancements);
            }
        });
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    public T func_192166_a(JsonObject json, JsonDeserializationContext context) {
        return (T)((ICriterionInstance)this.deserializer.apply(json));
    }

    public void fulfillCriterion(PlayerAdvancements advancements, Predicate<T> validationPredicate) {
        Collection advancementListeners = Optional.ofNullable(this.listeners.get(advancements)).map(Collection::stream).orElseGet(Stream::empty).filter(listener -> validationPredicate.test(listener.func_192158_a())).collect(Collectors.toList());
        for (ICriterionTrigger.Listener listener2 : advancementListeners) {
            listener2.func_192159_a(advancements);
        }
    }
}

