/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;

public class BlockForgedVent
extends TetraWaterloggedBlock
implements IBlockCapabilityInteractive {
    static final String unlocalizedName = "forged_vent";
    @ObjectHolder(value="tetra:forged_vent")
    public static BlockForgedVent instance;
    public static final IntegerProperty propRotation;
    public static final BooleanProperty propX;
    public static final BooleanProperty propBroken;
    public static final BlockInteraction[] interactions;
    private static final ResourceLocation boltLootTable;
    private static final ResourceLocation ventLootTable;

    public BlockForgedVent() {
        super(ForgedBlockCommon.properties);
        this.hasItem = true;
        this.setRegistryName(unlocalizedName);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{propRotation, propX, propBroken});
    }

    private static boolean breakBolt(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction hitFace) {
        world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)propBroken, (Comparable)Boolean.valueOf(true)), 2);
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            LootTable table = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(boltLootTable);
            LootContext context = new LootContext.Builder(serverWorld).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(hand)).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216022_a(LootParameterSets.field_216267_h);
            table.func_216113_a(context).forEach(itemStack -> {
                if (!player.field_71071_by.func_70441_a(itemStack)) {
                    player.func_71019_a(itemStack, false);
                }
            });
            serverWorld.func_184133_a(null, pos, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 0.4f, 0.5f);
        }
        return true;
    }

    private static boolean breakBeam(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction hitFace) {
        List<BlockPos> connectedVents = BlockForgedVent.getConnectedBlocks(world, pos, new LinkedList<BlockPos>(), (Boolean)blockState.func_177229_b((IProperty)propX));
        if (connectedVents.stream().anyMatch(blockPos -> (Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)propBroken) == false)) {
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.4f, 2.0f);
            }
            return false;
        }
        connectedVents.forEach(blockPos -> {
            world.func_217378_a(null, 2001, blockPos, Block.func_196246_j((BlockState)world.func_180495_p(blockPos)));
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
        });
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            LootTable table = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(ventLootTable);
            LootContext context = new LootContext.Builder(serverWorld).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(hand)).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216022_a(LootParameterSets.field_216267_h);
            table.func_216113_a(context).forEach(itemStack -> {
                if (!player.field_71071_by.func_70441_a(itemStack)) {
                    player.func_71019_a(itemStack, false);
                }
            });
        }
        return true;
    }

    private static List<BlockPos> getConnectedBlocks(World world, BlockPos pos, List<BlockPos> visited, boolean isXAxis) {
        if (!visited.contains(pos) && world.func_180495_p(pos).func_177230_c() instanceof BlockForgedVent) {
            visited.add(pos);
            BlockForgedVent.getConnectedBlocks(world, pos.func_177984_a(), visited, isXAxis);
            BlockForgedVent.getConnectedBlocks(world, pos.func_177977_b(), visited, isXAxis);
            if (isXAxis) {
                BlockForgedVent.getConnectedBlocks(world, pos.func_177974_f(), visited, isXAxis);
                BlockForgedVent.getConnectedBlocks(world, pos.func_177976_e(), visited, isXAxis);
            } else {
                BlockForgedVent.getConnectedBlocks(world, pos.func_177978_c(), visited, isXAxis);
                BlockForgedVent.getConnectedBlocks(world, pos.func_177968_d(), visited, isXAxis);
            }
        }
        return visited;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(BlockState state, Direction face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (Boolean)state.func_177229_b((IProperty)propX) != false ? Direction.EAST : Direction.SOUTH, face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, rayTrace);
    }

    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = super.func_196258_a(context);
        Direction playerFacing = context.func_195999_j() != null ? context.func_195999_j().func_174811_aO() : Direction.NORTH;
        blockState = blockState != null ? blockState : this.func_176223_P();
        blockState = (BlockState)blockState.func_206870_a((IProperty)propX, (Comparable)Boolean.valueOf(Direction.Axis.X.equals((Object)playerFacing.func_176740_k())));
        int rotation = 0;
        if (Direction.EAST.equals((Object)playerFacing) || Direction.SOUTH.equals((Object)playerFacing)) {
            rotation = 2;
        }
        if (context.func_196000_l() != Direction.UP && (context.func_196000_l() == Direction.DOWN || context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5)) {
            ++rotation;
        }
        blockState = (BlockState)((BlockState)blockState.func_206870_a((IProperty)propRotation, (Comparable)Integer.valueOf(rotation))).func_206870_a((IProperty)propBroken, (Comparable)Boolean.valueOf(false));
        return blockState;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        boolean isXAxis = (Boolean)state.func_177229_b((IProperty)propX);
        if (rot.equals((Object)Rotation.CLOCKWISE_90) || rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            state = (BlockState)state.func_206870_a((IProperty)propX, (Comparable)Boolean.valueOf(!isXAxis));
        }
        if (rot.equals((Object)Rotation.CLOCKWISE_180) || !isXAxis && rot.equals((Object)Rotation.CLOCKWISE_90) || isXAxis && rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            return (BlockState)state.func_206870_a((IProperty)propRotation, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)propRotation) ^ 2));
        }
        return (BlockState)state.func_206870_a((IProperty)propRotation, state.func_177229_b((IProperty)propRotation));
    }

    public boolean func_220060_c(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext contex) {
        if (((Boolean)state.func_177229_b((IProperty)propX)).booleanValue()) {
            return BlockForgedVent.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        }
        return BlockForgedVent.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return 0;
    }

    static {
        propRotation = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
        propX = BooleanProperty.func_177716_a((String)"x");
        propBroken = BooleanProperty.func_177716_a((String)"broken");
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.hammer, 3, Direction.EAST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.EAST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.EAST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.EAST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.WEST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.WEST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.WEST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.hammer, 3, Direction.WEST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), BlockForgedVent::breakBolt), new BlockInteraction(Capability.pry, 1, Direction.EAST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), BlockForgedVent::breakBeam), new BlockInteraction(Capability.pry, 1, Direction.WEST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), BlockForgedVent::breakBeam)};
        boltLootTable = new ResourceLocation("tetra", "forged/bolt_break");
        ventLootTable = new ResourceLocation("tetra", "forged/vent_break");
    }
}

