/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerScreen;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTESR;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.TileEntityOptional;

public class ForgedContainerBlock
extends TetraWaterloggedBlock
implements IBlockCapabilityInteractive {
    public static final String unlocalizedName = "forged_container";
    @ObjectHolder(value="tetra:forged_container")
    public static ForgedContainerBlock instance;
    public static final DirectionProperty facingProp;
    public static final BooleanProperty flippedProp;
    public static final BooleanProperty locked1Prop;
    public static final BooleanProperty locked2Prop;
    public static final BooleanProperty anyLockedProp;
    public static final BooleanProperty openProp;
    public static final BlockInteraction[] interactions;
    private static VoxelShape shapeZ1;
    private static VoxelShape shapeZ2;
    private static VoxelShape shapeX1;
    private static VoxelShape shapeX2;
    private static VoxelShape shapeZ1Open;
    private static VoxelShape shapeZ2Open;
    private static VoxelShape shapeX1Open;
    private static VoxelShape shapeX2Open;

    public ForgedContainerBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)facingProp, (Comparable)Direction.EAST)).func_206870_a((IProperty)flippedProp, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)openProp, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)locked1Prop, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)locked2Prop, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)anyLockedProp, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(ForgedContainerTile.class, (TileEntityRenderer)new ForgedContainerTESR());
        ScreenManager.func_216911_a(ForgedContainerContainer.type, ForgedContainerScreen::new);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        packetHandler.registerPacket(ChangeCompartmentPacket.class, ChangeCompartmentPacket::new);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    private static boolean breakLock(World world, BlockPos pos, PlayerEntity player, int index, Hand hand) {
        ForgedContainerTile te = (ForgedContainerTile)world.func_175625_s(pos);
        if (te != null) {
            te.getOrDelegate().breakLock(player, index, hand);
        }
        return true;
    }

    private static boolean open(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction facing) {
        ForgedContainerTile te = (ForgedContainerTile)world.func_175625_s(pos);
        if (te != null) {
            te.getOrDelegate().open(player);
        }
        return true;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(BlockState state, Direction face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (Direction)state.func_177229_b((IProperty)facingProp), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean didInteract = BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
        if (!didInteract) {
            if (!world.field_72995_K) {
                TileEntityOptional.from((IBlockReader)world, pos, ForgedContainerTile.class).ifPresent(te -> {
                    ForgedContainerTile delegate = te.getOrDelegate();
                    if (delegate.isOpen()) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)delegate, (BlockPos)delegate.func_174877_v());
                    }
                });
            }
        } else {
            world.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            if (((Boolean)state.func_177229_b((IProperty)openProp)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)flippedProp)).booleanValue()) {
                TileEntityOptional.from((IBlockReader)world, pos, ForgedContainerTile.class).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        ItemStack itemStack = cap.getStackInSlot(i);
                        if (itemStack.func_190926_b()) continue;
                        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack.func_77946_l());
                    }
                });
            }
            TileEntityOptional.from((IBlockReader)world, pos, ForgedContainerTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)facingProp);
        boolean flipped = (Boolean)state.func_177229_b((IProperty)flippedProp);
        if (((Boolean)state.func_177229_b((IProperty)openProp)).booleanValue()) {
            if (flipped) {
                switch (facing) {
                    case NORTH: {
                        return shapeX1Open;
                    }
                    case EAST: {
                        return shapeZ1Open;
                    }
                    case SOUTH: {
                        return shapeX2Open;
                    }
                    case WEST: {
                        return shapeZ2Open;
                    }
                }
            } else {
                switch (facing) {
                    case NORTH: {
                        return shapeX2Open;
                    }
                    case EAST: {
                        return shapeZ2Open;
                    }
                    case SOUTH: {
                        return shapeX1Open;
                    }
                    case WEST: {
                        return shapeZ1Open;
                    }
                }
            }
        } else if (flipped) {
            switch (facing) {
                case NORTH: {
                    return shapeX1;
                }
                case EAST: {
                    return shapeZ1;
                }
                case SOUTH: {
                    return shapeX2;
                }
                case WEST: {
                    return shapeZ2;
                }
            }
        } else {
            switch (facing) {
                case NORTH: {
                    return shapeX2;
                }
                case EAST: {
                    return shapeZ2;
                }
                case SOUTH: {
                    return shapeX1;
                }
                case WEST: {
                    return shapeZ1;
                }
            }
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{facingProp, flippedProp, locked1Prop, locked2Prop, anyLockedProp, openProp});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ForgedContainerTile();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_195992_f().func_176746_e())).func_196953_a(context)) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)facingProp, (Comparable)context.func_195992_f());
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.func_177229_b((IProperty)facingProp);
        world.func_180501_a(pos.func_177972_a(facing.func_176746_e()), (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)flippedProp, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)facingProp, (Comparable)facing), 3);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction pairedFacing = (Direction)state.func_177229_b((IProperty)facingProp);
        pairedFacing = (Boolean)state.func_177229_b((IProperty)flippedProp) != false ? pairedFacing.func_176735_f() : pairedFacing.func_176746_e();
        if (pairedFacing == facing && !this.equals(facingState.func_177230_c())) {
            return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        Direction facing = (Direction)state.func_177229_b((IProperty)facingProp);
        if (Rotation.CLOCKWISE_180.equals((Object)rot) || Rotation.CLOCKWISE_90.equals((Object)rot) && (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) || Rotation.COUNTERCLOCKWISE_90.equals((Object)rot) && (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing))) {
            state = (BlockState)state.func_206870_a((IProperty)flippedProp, state.func_177229_b((IProperty)flippedProp));
        }
        return (BlockState)state.func_206870_a((IProperty)facingProp, (Comparable)rot.func_185831_a(facing));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)facingProp)));
    }

    static {
        facingProp = HorizontalBlock.field_185512_D;
        flippedProp = BooleanProperty.func_177716_a((String)"flipped");
        locked1Prop = BooleanProperty.func_177716_a((String)"locked1");
        locked2Prop = BooleanProperty.func_177716_a((String)"locked2");
        anyLockedProp = BooleanProperty.func_177716_a((String)"locked_any");
        openProp = BooleanProperty.func_177716_a((String)"open");
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.hammer, 3, Direction.SOUTH, 5.0f, 7.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked1Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)false)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 0, hand)), new BlockInteraction(Capability.hammer, 3, Direction.SOUTH, 11.0f, 13.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked2Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)false)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 1, hand)), new BlockInteraction(Capability.hammer, 3, Direction.SOUTH, 17.0f, 19.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked1Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)true)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 2, hand)), new BlockInteraction(Capability.hammer, 3, Direction.SOUTH, 23.0f, 25.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked2Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)true)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 3, hand)), new BlockInteraction(Capability.pry, 1, Direction.SOUTH, 1.0f, 15.0f, 3.0f, 4.0f, new PropertyMatcher().where(anyLockedProp, Predicates.equalTo((Object)false)).where(openProp, Predicates.equalTo((Object)false)).where(flippedProp, Predicates.equalTo((Object)false)), ForgedContainerBlock::open), new BlockInteraction(Capability.pry, 1, Direction.SOUTH, 15.0f, 28.0f, 3.0f, 4.0f, new PropertyMatcher().where(anyLockedProp, Predicates.equalTo((Object)false)).where(openProp, Predicates.equalTo((Object)false)).where(flippedProp, Predicates.equalTo((Object)true)), ForgedContainerBlock::open)};
        shapeZ1 = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)-15.0, (double)15.0, (double)12.0, (double)15.0);
        shapeZ2 = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)31.0);
        shapeX1 = ForgedContainerBlock.func_208617_a((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
        shapeX2 = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)31.0, (double)12.0, (double)15.0);
        shapeZ1Open = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)-15.0, (double)15.0, (double)9.0, (double)15.0);
        shapeZ2Open = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)31.0);
        shapeX1Open = ForgedContainerBlock.func_208617_a((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
        shapeX2Open = ForgedContainerBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)31.0, (double)9.0, (double)15.0);
    }
}

