/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;

public class CoreExtractorPipeBlock
extends TetraBlock {
    public static final DirectionProperty facingProp = DirectionalBlock.field_176387_N;
    public static final BooleanProperty poweredProp = BooleanProperty.func_177716_a((String)"powered");
    public static final String unlocalizedName = "extractor_pipe";
    @ObjectHolder(value="tetra:extractor_pipe")
    public static CoreExtractorPipeBlock instance;

    public CoreExtractorPipeBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public static boolean isPowered(World world, BlockPos pos) {
        BlockState pipeState = world.func_180495_p(pos);
        return instance.equals(pipeState.func_177230_c()) && (Boolean)pipeState.func_177229_b((IProperty)poweredProp) != false;
    }

    private boolean shouldGetPower(World world, BlockPos pos, Direction blockFacing) {
        for (Direction facing : Direction.values()) {
            BlockState adjacent;
            if (facing.equals((Object)blockFacing) || !(adjacent = world.func_180495_p(pos.func_177972_a(facing))).func_177230_c().equals(this) || !facing.equals((Object)((Direction)adjacent.func_177229_b((IProperty)facingProp)).func_176734_d()) || !((Boolean)adjacent.func_177229_b((IProperty)poweredProp)).booleanValue()) continue;
            return true;
        }
        return SeepingBedrockBlock.isActive(world, pos.func_177972_a(blockFacing.func_176734_d()));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        boolean getsPowered = this.shouldGetPower(world, pos, (Direction)state.func_177229_b((IProperty)facingProp));
        if ((Boolean)state.func_177229_b((IProperty)poweredProp) != getsPowered) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)poweredProp, (Comparable)Boolean.valueOf(getsPowered)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{facingProp, poweredProp});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)facingProp, (Comparable)context.func_196000_l())).func_206870_a((IProperty)poweredProp, (Comparable)Boolean.valueOf(this.shouldGetPower(context.func_195991_k(), context.func_195995_a(), context.func_196000_l())));
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return (BlockState)state.func_206870_a((IProperty)facingProp, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((IProperty)facingProp)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)facingProp)));
    }
}

