/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonTESR;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonUpdatePacket;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.TileEntityOptional;

public class CoreExtractorPistonBlock
extends TetraWaterloggedBlock {
    public static final String unlocalizedName = "extractor_piston";
    @ObjectHolder(value="tetra:extractor_piston")
    public static CoreExtractorPistonBlock instance;
    public static final BooleanProperty hackProp;
    public static final VoxelShape boundingBox;

    public CoreExtractorPistonBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(CoreExtractorPistonTile.class, (TileEntityRenderer)new CoreExtractorPistonTESR());
    }

    @Override
    public void init(PacketHandler packetHandler) {
        super.init(packetHandler);
        PacketHandler.instance.registerPacket(CoreExtractorPistonUpdatePacket.class, CoreExtractorPistonUpdatePacket::new);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityOptional.from((IBlockReader)worldIn, pos, CoreExtractorPistonTile.class).ifPresent(te -> {
            float random;
            if (te.isActive() && (random = rand.nextFloat()) < 0.6f) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.4 + rand.nextGaussian() * 0.2, (double)pos.func_177956_o() + rand.nextGaussian(), (double)pos.func_177952_p() + 0.4 + rand.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
            }
        });
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.DOWN.equals((Object)facing) && !CoreExtractorBaseBlock.instance.equals(facingState.func_177230_c())) {
            return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return boundingBox;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CoreExtractorPistonTile();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{hackProp});
    }

    static {
        hackProp = BooleanProperty.func_177716_a((String)"hack");
        boundingBox = CoreExtractorPistonBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    }
}

