/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerConfig;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerPlate;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.util.TileEntityOptional;

public class HammerBaseBlock
extends TetraBlock
implements IBlockCapabilityInteractive {
    public static final DirectionProperty propFacing = HorizontalBlock.field_185512_D;
    public static final BooleanProperty propCell1 = BooleanProperty.func_177716_a((String)"cell1");
    public static final BooleanProperty propCell1Charged = BooleanProperty.func_177716_a((String)"cell1charged");
    public static final BooleanProperty propCell2 = BooleanProperty.func_177716_a((String)"cell2");
    public static final BooleanProperty propCell2Charged = BooleanProperty.func_177716_a((String)"cell2charged");
    private static final ResourceLocation plateLootTable = new ResourceLocation("tetra", "forged/plate_break");
    public static final String unlocalizedName = "hammer_base";
    @ObjectHolder(value="tetra:hammer_base")
    public static HammerBaseBlock instance;
    public static final BlockInteraction[] interactions;

    public HammerBaseBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)EnumHammerPlate.east.prop, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EnumHammerPlate.west.prop, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)propCell1, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)propCell1Charged, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)propCell2, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)propCell2Charged, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent("block.multiblock_hint.1x2x1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
    }

    public boolean isFueled(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(HammerBaseTile::isFueled).orElse(false);
    }

    public void consumeFuel(World world, BlockPos pos) {
        TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(HammerBaseTile::consumeFuel);
    }

    public void applyEffects(World world, BlockPos pos, ItemStack itemStack, PlayerEntity player) {
        if (HammerBaseBlock.hasEffect(world, world.func_180495_p(pos), EnumHammerEffect.DAMAGING) && itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            int damage = (int)((double)itemStack.func_77958_k() * 0.1);
            item.applyDamage(damage, itemStack, (LivingEntity)player);
        }
    }

    public int getHammerLevel(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(HammerBaseTile::getHammerLevel).orElse(0);
    }

    public static boolean removePlate(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, EnumHammerPlate plate) {
        if (!world.field_72995_K) {
            BlockInteraction.dropLoot(plateLootTable, player, hand, (ServerWorld)world, blockState);
        }
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)plate.prop, (Comparable)Boolean.valueOf(false)), 3);
        world.func_184133_a(player, pos, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
        return true;
    }

    public static boolean reconfigure(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Direction face) {
        TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(te -> {
            if (Direction.EAST.equals((Object)face)) {
                EnumHammerConfig newConfig = EnumHammerConfig.getNextConfiguration((EnumHammerConfig)((Object)((Object)blockState.func_177229_b(EnumHammerConfig.eastProp))));
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a(EnumHammerConfig.eastProp, (Comparable)((Object)newConfig)), 3);
                te.applyReconfigurationEffect();
            } else if (Direction.WEST.equals((Object)face)) {
                EnumHammerConfig newConfig = EnumHammerConfig.getNextConfiguration((EnumHammerConfig)((Object)((Object)blockState.func_177229_b(EnumHammerConfig.westProp))));
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a(EnumHammerConfig.westProp, (Comparable)((Object)newConfig)), 3);
                te.applyReconfigurationEffect();
            }
            world.func_184133_a(player, pos, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 1.0f, 1.0f);
        });
        return true;
    }

    public static boolean hasEffect(World world, BlockState blockState, EnumHammerEffect effect) {
        if (effect.requiresBoth) {
            return effect.equals((Object)EnumHammerEffect.fromConfig((EnumHammerConfig)((Object)blockState.func_177229_b(EnumHammerConfig.eastProp)), world.func_72905_C())) && effect.equals((Object)EnumHammerEffect.fromConfig((EnumHammerConfig)((Object)blockState.func_177229_b(EnumHammerConfig.westProp)), world.func_72905_C()));
        }
        return effect.equals((Object)EnumHammerEffect.fromConfig((EnumHammerConfig)((Object)blockState.func_177229_b(EnumHammerConfig.eastProp)), world.func_72905_C())) || effect.equals((Object)EnumHammerEffect.fromConfig((EnumHammerConfig)((Object)blockState.func_177229_b(EnumHammerConfig.westProp)), world.func_72905_C()));
    }

    public boolean func_220051_a(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        Direction blockFacing = (Direction)blockState.func_177229_b((IProperty)propFacing);
        HammerBaseTile te = TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).orElse(null);
        ItemStack heldStack = player.func_184586_b(hand);
        Direction facing = rayTraceResult.func_216354_b();
        if (te == null) {
            return false;
        }
        if (blockFacing.func_176740_k().equals((Object)facing.func_176740_k())) {
            int slotIndex;
            int n = slotIndex = blockFacing.equals((Object)facing) ? 0 : 1;
            if (te.hasCellInSlot(slotIndex)) {
                ItemStack cell = te.removeCellFromSlot(slotIndex);
                if (player.field_71071_by.func_70441_a(cell)) {
                    player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                } else {
                    HammerBaseBlock.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)cell);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), ItemStack.field_190927_a);
                }
                return true;
            }
            if (heldStack.func_77973_b() instanceof ItemCellMagmatic) {
                te.putCellInSlot(heldStack, slotIndex);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), heldStack);
                }
                return true;
            }
        } else if (heldStack.func_77973_b() instanceof ItemVentPlate) {
            if (Rotation.CLOCKWISE_90.func_185831_a(blockFacing).equals((Object)facing) && !((Boolean)blockState.func_177229_b((IProperty)EnumHammerPlate.east.prop)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)EnumHammerPlate.east.prop, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), heldStack);
                }
                heldStack.func_190918_g(1);
                return true;
            }
            if (Rotation.COUNTERCLOCKWISE_90.func_185831_a(blockFacing).equals((Object)facing) && !((Boolean)blockState.func_177229_b((IProperty)EnumHammerPlate.west.prop)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)EnumHammerPlate.west.prop, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), heldStack);
                }
                heldStack.func_190918_g(1);
                return true;
            }
        }
        return BlockInteraction.attemptInteraction(world, world.func_180495_p(pos), pos, player, hand, rayTraceResult);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(tile -> {
                for (int i = 0; i < 2; ++i) {
                    if (!tile.hasCellInSlot(i)) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.getStackInSlot(i).func_77946_l());
                }
            });
            TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(BlockState state, Direction face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (Direction)state.func_177229_b((IProperty)propFacing), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_200124_e(BlockState state) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HammerBaseTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{propFacing, propCell1, propCell1Charged, propCell2, propCell2Charged, EnumHammerPlate.east.prop, EnumHammerPlate.west.prop, EnumHammerConfig.eastProp, EnumHammerConfig.westProp});
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.DOWN.equals((Object)facing) && !HammerHeadBlock.instance.equals(facingState.func_177230_c())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState headState = (BlockState)HammerHeadBlock.instance.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177977_b()).func_206886_c() == Fluids.field_204546_a));
        world.func_180501_a(pos.func_177977_b(), headState, 3);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_196953_a(context)) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)propFacing, (Comparable)context.func_195992_f().func_176734_d());
        }
        return null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)propFacing, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)propFacing)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)propFacing)));
    }

    static {
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, EnumHammerPlate.east.face, 5.0f, 11.0f, 9.0f, 11.0f, EnumHammerPlate.east.prop, true, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removePlate(world, pos, blockState, player, hand, EnumHammerPlate.east)), new BlockInteraction(Capability.pry, 1, EnumHammerPlate.west.face, 5.0f, 11.0f, 9.0f, 11.0f, EnumHammerPlate.west.prop, true, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removePlate(world, pos, blockState, player, hand, EnumHammerPlate.west)), new BlockInteraction(Capability.hammer, 1, Direction.EAST, 6.0f, 10.0f, 2.0f, 9.0f, EnumHammerPlate.east.prop, false, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.reconfigure(world, pos, blockState, player, Direction.EAST)), new BlockInteraction(Capability.hammer, 1, Direction.WEST, 6.0f, 10.0f, 2.0f, 9.0f, EnumHammerPlate.west.prop, false, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.reconfigure(world, pos, blockState, player, Direction.WEST))};
    }
}

