/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTESR;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.util.TileEntityOptional;

public class HammerHeadBlock
extends TetraWaterloggedBlock {
    public static final String unlocalizedName = "hammer_head";
    public static final VoxelShape shape = HammerHeadBlock.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    @ObjectHolder(value="tetra:hammer_head")
    public static HammerHeadBlock instance;

    public HammerHeadBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
        this.hasItem = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(HammerHeadTile.class, (TileEntityRenderer)new HammerHeadTESR());
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    @Override
    public Collection<Capability> getCapabilities(World world, BlockPos pos, BlockState blockState) {
        HammerBaseBlock baseBlock;
        BlockPos basePos = pos.func_177972_a(Direction.UP);
        if (world.func_180495_p(basePos).func_177230_c() instanceof HammerBaseBlock && (baseBlock = (HammerBaseBlock)world.func_180495_p(basePos).func_177230_c()).isFueled(world, basePos)) {
            return Collections.singletonList(Capability.hammer);
        }
        return super.getCapabilities(world, pos, blockState);
    }

    @Override
    public int getCapabilityLevel(World world, BlockPos pos, BlockState blockState, Capability capability) {
        HammerBaseBlock baseBlock;
        BlockPos basePos = pos.func_177972_a(Direction.UP);
        if (Capability.hammer.equals((Object)capability) && world.func_180495_p(basePos).func_177230_c() instanceof HammerBaseBlock && (baseBlock = (HammerBaseBlock)world.func_180495_p(basePos).func_177230_c()).isFueled(world, basePos)) {
            return baseBlock.getHammerLevel(world, basePos);
        }
        return super.getCapabilityLevel(world, pos, blockState, capability);
    }

    @Override
    public ItemStack onCraftConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, boolean consumeResources) {
        BlockPos basePos = pos.func_177972_a(Direction.UP);
        if (consumeResources && world.func_180495_p(basePos).func_177230_c() instanceof HammerBaseBlock) {
            HammerBaseBlock baseBlock = (HammerBaseBlock)world.func_180495_p(basePos).func_177230_c();
            baseBlock.consumeFuel(world, basePos);
            baseBlock.applyEffects(world, basePos, targetStack, player);
            TileEntityOptional.from((IBlockReader)world, pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 3.0f, (float)(0.5 + Math.random() * 0.1));
        }
        return targetStack;
    }

    @Override
    public ItemStack onActionConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, boolean consumeResources) {
        BlockPos basePos = pos.func_177972_a(Direction.UP);
        if (consumeResources && world.func_180495_p(basePos).func_177230_c() instanceof HammerBaseBlock) {
            HammerBaseBlock baseBlock = (HammerBaseBlock)world.func_180495_p(basePos).func_177230_c();
            baseBlock.consumeFuel(world, basePos);
            TileEntityOptional.from((IBlockReader)world, pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 3.0f, (float)(0.5 + Math.random() * 0.1));
        }
        return targetStack;
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.UP.equals((Object)facing) && !HammerBaseBlock.instance.equals(facingState.func_177230_c())) {
            return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HammerHeadTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

