/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.IHeatTransfer;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferEffect;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.TileEntityOptional;

public class TransferUnitTile
extends TileEntity
implements ITickableTileEntity,
IHeatTransfer {
    @ObjectHolder(value="tetra:transfer_unit")
    public static TileEntityType<TransferUnitTile> type;
    private ItemStack cell = ItemStack.field_190927_a;
    private static final int baseAmount = 8;
    private float efficiency = 1.0f;

    public TransferUnitTile() {
        super(type);
    }

    @Override
    public boolean canRecieve() {
        return TransferUnitBlock.getEffectPowered(this.field_145850_b, this.field_174879_c, this.func_195044_w()).equals((Object)EnumTransferEffect.receive) && this.hasCell() && this.getCharge() < 128;
    }

    @Override
    public boolean canSend() {
        return TransferUnitBlock.getEffectPowered(this.field_145850_b, this.field_174879_c, this.func_195044_w()).equals((Object)EnumTransferEffect.send) && this.hasCell() && this.getCharge() > 0;
    }

    @Override
    public void setReceiving(boolean receiving) {
        TransferUnitBlock.setReceiving(this.field_145850_b, this.field_174879_c, this.func_195044_w(), receiving);
    }

    @Override
    public boolean isReceiving() {
        return TransferUnitBlock.isReceiving(this.func_195044_w());
    }

    @Override
    public void setSending(boolean sending) {
        TransferUnitBlock.setSending(this.field_145850_b, this.field_174879_c, this.func_195044_w(), sending);
    }

    @Override
    public boolean isSending() {
        return TransferUnitBlock.isSending(this.func_195044_w());
    }

    public boolean hasCell() {
        return !this.cell.func_190926_b();
    }

    public ItemStack removeCell() {
        ItemStack removedCell = this.cell;
        this.cell = ItemStack.field_190927_a;
        TransferUnitBlock.updateCellProp(this.field_145850_b, this.field_174879_c, this.hasCell(), this.getCharge());
        this.updateTransferState();
        return removedCell;
    }

    public ItemStack getCell() {
        return this.cell;
    }

    public boolean putCell(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemCellMagmatic) {
            this.cell = itemStack;
            TransferUnitBlock.updateCellProp(this.field_145850_b, this.field_174879_c, this.hasCell(), this.getCharge());
            this.updateTransferState();
            return true;
        }
        return false;
    }

    private Optional<IHeatTransfer> getConnectedUnit() {
        return TileEntityOptional.from((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(TransferUnitBlock.getFacing(this.func_195044_w())), IHeatTransfer.class);
    }

    @Override
    public int getCharge() {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> item.getCharge(this.cell)).orElse(0);
    }

    @Override
    public float getEfficiency() {
        return TransferUnitBlock.hasPlate(this.func_195044_w()) ? 1.0f : 0.9f;
    }

    @Override
    public int getReceiveLimit() {
        return 8;
    }

    @Override
    public int getSendLimit() {
        return 8;
    }

    @Override
    public int drain(int amount) {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> {
            int drained = item.drainCharge(this.cell, amount);
            if (item.getCharge(this.cell) == 0) {
                TransferUnitBlock.updateCellProp(this.field_145850_b, this.field_174879_c, this.hasCell(), 0);
                this.runDrainedEffects();
            }
            return drained;
        }).orElse(0);
    }

    @Override
    public int fill(int amount) {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> {
            int initialCharge = item.getCharge(this.cell);
            int overfill = item.recharge(this.cell, amount);
            if (item.getCharge(this.cell) == 128) {
                this.runFilledEffects();
            }
            if (initialCharge == 0) {
                TransferUnitBlock.updateCellProp(this.field_145850_b, this.field_174879_c, this.hasCell(), this.getCharge());
            }
            this.func_70296_d();
            return overfill;
        }).orElse(0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L && TransferUnitBlock.isSending(this.func_195044_w())) {
            this.transfer();
        }
    }

    public void transfer() {
        if (this.canSend()) {
            this.getConnectedUnit().ifPresent(connected -> {
                if (connected.canRecieve()) {
                    int amount = this.drain(8);
                    int overfill = connected.fill((int)((float)amount * this.efficiency));
                    if (overfill > 0) {
                        this.fill(overfill);
                    }
                    this.func_70296_d();
                } else {
                    this.setSending(false);
                    connected.setReceiving(false);
                }
            });
        } else {
            this.getConnectedUnit().ifPresent(connected -> connected.setReceiving(false));
            this.setSending(false);
        }
    }

    private void runDrainedEffects() {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.5, 10, 0.0, 0.0, 0.0, (double)0.02f);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    private void runFilledEffects() {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public void updateTransferState() {
        switch (TransferUnitBlock.getEffectPowered(this.field_145850_b, this.field_174879_c, this.func_195044_w())) {
            case send: {
                this.getConnectedUnit().ifPresent(connected -> {
                    boolean canTransfer = this.canSend() && connected.canRecieve();
                    this.setReceiving(false);
                    this.setSending(canTransfer);
                    connected.setReceiving(canTransfer);
                    this.efficiency = this.getEfficiency() * connected.getEfficiency();
                });
                break;
            }
            case receive: {
                this.getConnectedUnit().ifPresent(connected -> {
                    if (this.isSending()) {
                        this.setSending(false);
                    }
                    if (connected.canSend()) {
                        connected.updateTransferState();
                    }
                });
                break;
            }
            case redstone: {
                this.getConnectedUnit().ifPresent(connected -> {
                    connected.setSending(false);
                    connected.setReceiving(false);
                    this.setSending(false);
                    this.setReceiving(false);
                });
            }
        }
        this.func_70296_d();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.cell = compound.func_74764_b("cell") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("cell")) : ItemStack.field_190927_a;
    }

    public static final void writeCell(CompoundNBT compound, ItemStack cell) {
        if (!cell.func_190926_b()) {
            CompoundNBT cellNBT = new CompoundNBT();
            cell.func_77955_b(cellNBT);
            compound.func_218657_a("cell", (INBT)cellNBT);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        TransferUnitTile.writeCell(compound, this.cell);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

