/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import se.mickelus.tetra.RotationHelper;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.items.modular.ItemModular;

public class BlockInteraction {
    public Capability requiredCapability;
    public int requiredLevel;
    public boolean alwaysReveal = true;
    public Direction face;
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;
    public Predicate<BlockState> predicate;
    public InteractionOutcome outcome;
    public float successChance = 1.0f;

    public <V extends Comparable<V>> BlockInteraction(Capability requiredCapability, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Property<V> property, V propertyValue, InteractionOutcome outcome) {
        this.requiredCapability = requiredCapability;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.predicate = new PropertyMatcher().where(property, Predicates.equalTo(propertyValue));
        this.outcome = outcome;
    }

    public BlockInteraction(Capability requiredCapability, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Predicate<BlockState> predicate, InteractionOutcome outcome) {
        this.requiredCapability = requiredCapability;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.predicate = predicate;
        this.outcome = outcome;
    }

    public boolean applicableForState(BlockState blockState) {
        return this.predicate.test(blockState);
    }

    public boolean isWithinBounds(double x, double y) {
        return (double)this.minX <= x && x <= (double)this.maxX && (double)this.minY <= y && y <= (double)this.maxY;
    }

    public boolean isPotentialInteraction(BlockState blockState, Direction hitFace, Collection<Capability> availableCapabilities) {
        return this.isPotentialInteraction(blockState, Direction.NORTH, hitFace, availableCapabilities);
    }

    public boolean isPotentialInteraction(BlockState blockState, Direction blockFacing, Direction hitFace, Collection<Capability> availableCapabilities) {
        return this.applicableForState(blockState) && RotationHelper.rotationFromFacing(blockFacing).func_185831_a(this.face).equals((Object)hitFace) && (this.alwaysReveal || availableCapabilities.contains((Object)this.requiredCapability));
    }

    public void applyOutcome(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction hitFace) {
        this.outcome.apply(world, pos, blockState, player, hand, hitFace);
    }

    public static boolean attemptInteraction(World world, BlockState blockState, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        ItemStack heldStack = player.func_184586_b(hand);
        Collection<Capability> availableCapabilities = CapabilityHelper.getItemCapabilities(heldStack);
        if ((double)player.func_184825_o(0.0f) < 0.8) {
            player.func_184821_cY();
            return false;
        }
        AxisAlignedBB boundingBox = blockState.func_196954_c((IBlockReader)world, pos).func_197752_a();
        double hitU = 16.0 * BlockInteraction.getHitU(rayTrace.func_216354_b(), boundingBox, rayTrace.func_216347_e().field_72450_a - (double)pos.func_177958_n(), rayTrace.func_216347_e().field_72448_b - (double)pos.func_177956_o(), rayTrace.func_216347_e().field_72449_c - (double)pos.func_177952_p());
        double hitV = 16.0 * BlockInteraction.getHitV(rayTrace.func_216354_b(), boundingBox, rayTrace.func_216347_e().field_72450_a - (double)pos.func_177958_n(), rayTrace.func_216347_e().field_72448_b - (double)pos.func_177956_o(), rayTrace.func_216347_e().field_72449_c - (double)pos.func_177952_p());
        BlockInteraction possibleInteraction = Optional.of(blockState.func_177230_c()).filter(block -> block instanceof IBlockCapabilityInteractive).map(block -> (IBlockCapabilityInteractive)block).map(block -> block.getPotentialInteractions(blockState, rayTrace.func_216354_b(), availableCapabilities)).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU, hitV)).filter(interaction -> CapabilityHelper.getItemCapabilityLevel(heldStack, interaction.requiredCapability) >= interaction.requiredLevel).findFirst().orElse(null);
        if (possibleInteraction != null) {
            possibleInteraction.applyOutcome(world, pos, blockState, player, hand, rayTrace.func_216354_b());
            if (availableCapabilities.contains((Object)possibleInteraction.requiredCapability) && heldStack.func_77984_f()) {
                if (heldStack.func_77973_b() instanceof ItemModular) {
                    ((ItemModular)heldStack.func_77973_b()).applyDamage(2, heldStack, (LivingEntity)player);
                } else {
                    heldStack.func_222118_a(2, (LivingEntity)player, breaker -> breaker.func_213334_d(breaker.func_184600_cs()));
                }
            }
            if (player instanceof ServerPlayerEntity) {
                BlockState newState = world.func_180495_p(pos);
                BlockInteractionCriterion.trigger((ServerPlayerEntity)player, newState, possibleInteraction.requiredCapability, possibleInteraction.requiredLevel);
            }
            player.func_184821_cY();
            return true;
        }
        return false;
    }

    public static BlockInteraction getInteractionAtPoint(PlayerEntity player, BlockState blockState, BlockPos pos, Direction hitFace, double hitX, double hitY, double hitZ) {
        AxisAlignedBB boundingBox = blockState.func_196954_c((IBlockReader)player.field_70170_p, pos).func_197752_a();
        double hitU = BlockInteraction.getHitU(hitFace, boundingBox, hitX, hitY, hitZ);
        double hitV = BlockInteraction.getHitV(hitFace, boundingBox, hitX, hitY, hitZ);
        return Optional.of(blockState.func_177230_c()).filter(block -> block instanceof IBlockCapabilityInteractive).map(block -> (IBlockCapabilityInteractive)block).map(block -> block.getPotentialInteractions(blockState, hitFace, CapabilityHelper.getPlayerCapabilities(player))).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU * 16.0, hitV * 16.0)).findFirst().orElse(null);
    }

    private static double getHitU(Direction facing, AxisAlignedBB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.field_72336_d - hitX;
            }
            case UP: {
                return boundingBox.field_72336_d - hitX;
            }
            case NORTH: {
                return boundingBox.field_72336_d - hitX;
            }
            case SOUTH: {
                return hitX - boundingBox.field_72340_a;
            }
            case WEST: {
                return hitZ - boundingBox.field_72339_c;
            }
            case EAST: {
                return boundingBox.field_72334_f - hitZ;
            }
        }
        return 0.0;
    }

    private static double getHitV(Direction facing, AxisAlignedBB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.field_72334_f - hitZ;
            }
            case UP: {
                return boundingBox.field_72334_f - hitZ;
            }
            case NORTH: {
                return boundingBox.field_72337_e - hitY;
            }
            case SOUTH: {
                return boundingBox.field_72337_e - hitY;
            }
            case WEST: {
                return boundingBox.field_72337_e - hitY;
            }
            case EAST: {
                return boundingBox.field_72337_e - hitY;
            }
        }
        return 0.0;
    }

    public static List<ItemStack> getLoot(ResourceLocation lootTable, PlayerEntity player, Hand hand, ServerWorld world, BlockState blockState) {
        LootTable table = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
        LootContext context = new LootContext.Builder(world).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(hand)).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216022_a(LootParameterSets.field_216267_h);
        return table.func_216113_a(context);
    }

    public static void dropLoot(ResourceLocation lootTable, PlayerEntity player, Hand hand, ServerWorld world, BlockState blockState) {
        BlockInteraction.getLoot(lootTable, player, hand, world, blockState).forEach(itemStack -> {
            if (!player.field_71071_by.func_70441_a(itemStack)) {
                player.func_71019_a(itemStack, false);
            }
        });
    }
}

