/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.util.TileEntityOptional;

public abstract class AbstractWorkbenchBlock
extends TetraBlock {
    public AbstractWorkbenchBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(te -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos));
        }
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).ifPresent(cap -> {
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack itemStack = cap.getStackInSlot(i);
                    if (itemStack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack.func_77946_l());
                }
            });
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    @Override
    public Collection<Capability> getCapabilities(World world, BlockPos pos, BlockState blockState) {
        BlockState accessoryBlockState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        if (accessoryBlockState.func_177230_c() instanceof ITetraBlock) {
            ITetraBlock block = (ITetraBlock)accessoryBlockState.func_177230_c();
            return block.getCapabilities(world, pos.func_177972_a(Direction.UP), accessoryBlockState);
        }
        return Collections.emptyList();
    }

    @Override
    public int getCapabilityLevel(World world, BlockPos pos, BlockState blockState, Capability capability) {
        BlockState accessoryBlockState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        if (accessoryBlockState.func_177230_c() instanceof ITetraBlock) {
            ITetraBlock block = (ITetraBlock)accessoryBlockState.func_177230_c();
            return block.getCapabilityLevel(world, pos.func_177972_a(Direction.UP), accessoryBlockState, capability);
        }
        return -1;
    }

    @Override
    public ItemStack onCraftConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, boolean consumeResources) {
        BlockPos topPos = pos.func_177972_a(Direction.UP);
        if (world.func_180495_p(topPos).func_177230_c() instanceof HammerHeadBlock) {
            HammerHeadBlock hammer = (HammerHeadBlock)world.func_180495_p(topPos).func_177230_c();
            return hammer.onCraftConsumeCapability(world, topPos, world.func_180495_p(topPos), targetStack, player, consumeResources);
        }
        return targetStack;
    }

    @Override
    public ItemStack onActionConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, boolean consumeResources) {
        BlockPos topPos = pos.func_177972_a(Direction.UP);
        if (world.func_180495_p(topPos).func_177230_c() instanceof HammerHeadBlock) {
            HammerHeadBlock hammer = (HammerHeadBlock)world.func_180495_p(topPos).func_177230_c();
            return hammer.onActionConsumeCapability(world, topPos, world.func_180495_p(topPos), targetStack, player, consumeResources);
        }
        return targetStack;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WorkbenchTile();
    }
}

