/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketCraft;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketTweak;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketUpdate;
import se.mickelus.tetra.blocks.workbench.action.ConfigAction;
import se.mickelus.tetra.blocks.workbench.action.RepairAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchActionPacket;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.CastOptional;

public class WorkbenchTile
extends TileEntity
implements INamedContainerProvider {
    public static final String unlocalizedName = "workbench";
    @ObjectHolder(value="tetra:workbench")
    public static TileEntityType<WorkbenchTile> type;
    @ObjectHolder(value="tetra:workbench")
    public static ContainerType<WorkbenchContainer> containerType;
    private static final String inventoryKey = "inv";
    private static final String currentSlotKey = "current_slot";
    private static final String schemaKey = "schema";
    public static final int inventorySlots = 4;
    private ItemStack previousTarget = ItemStack.field_190927_a;
    private UpgradeSchema currentSchema;
    private String currentSlot;
    private Map<String, Runnable> changeListeners;
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(this::createHandler);
    private static WorkbenchAction[] defaultActions;
    private static WorkbenchAction[] actions;

    public WorkbenchTile() {
        super(type);
        this.changeListeners = new HashMap<String, Runnable>();
    }

    public static void init(PacketHandler packetHandler) {
        packetHandler.registerPacket(WorkbenchPacketUpdate.class, WorkbenchPacketUpdate::new);
        packetHandler.registerPacket(WorkbenchPacketCraft.class, WorkbenchPacketCraft::new);
        packetHandler.registerPacket(WorkbenchActionPacket.class, WorkbenchActionPacket::new);
        packetHandler.registerPacket(WorkbenchPacketTweak.class, WorkbenchPacketTweak::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull net.minecraftforge.common.capabilities.Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (slot == 0 && (itemStack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)WorkbenchTile.this.getTargetItemStack(), (ItemStack)itemStack))) {
                    WorkbenchTile.this.currentSchema = null;
                    WorkbenchTile.this.currentSlot = null;
                    WorkbenchTile.this.emptyMaterialSlots();
                }
                WorkbenchTile.this.func_70296_d();
            }

            public int getSlots() {
                if (WorkbenchTile.this.currentSchema != null) {
                    return WorkbenchTile.this.currentSchema.getNumMaterialSlots() + 1;
                }
                return 1;
            }
        };
    }

    public WorkbenchAction[] getAvailableActions(PlayerEntity player) {
        ItemStack itemStack = this.getTargetItemStack();
        return (WorkbenchAction[])Arrays.stream(actions).filter(action -> action.canPerformOn(player, itemStack)).toArray(WorkbenchAction[]::new);
    }

    public void performAction(PlayerEntity player, String actionKey) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new WorkbenchActionPacket(this.field_174879_c, actionKey));
            return;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(player, targetStack)).filter(action -> this.checkActionCapabilities(player, (WorkbenchAction)action, targetStack)).ifPresent(action -> {
            for (Capability capability : action.getRequiredCapabilitiesFor(targetStack)) {
                int requiredLevel = action.getCapabilityLevel(targetStack, capability);
                ItemStack providingStack = CapabilityHelper.getProvidingItemStack(capability, requiredLevel, (Entity)player);
                if (!providingStack.func_190926_b()) {
                    if (!(providingStack.func_77973_b() instanceof ItemModular)) continue;
                    ((ItemModular)providingStack.func_77973_b()).onActionConsumeCapability(providingStack, targetStack, player, capability, requiredLevel, true);
                    continue;
                }
                CastOptional.cast(this.func_195044_w().func_177230_c(), AbstractWorkbenchBlock.class).ifPresent(block -> block.onActionConsumeCapability(this.field_145850_b, this.func_174877_v(), blockState, targetStack, player, true));
            }
            action.perform(player, targetStack, this);
        });
    }

    private boolean checkActionCapabilities(PlayerEntity player, WorkbenchAction action, ItemStack itemStack) {
        return Arrays.stream(action.getRequiredCapabilitiesFor(itemStack)).allMatch(capability -> CapabilityHelper.getCombinedCapabilityLevel(player, this.func_145831_w(), this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), capability) >= action.getCapabilityLevel(itemStack, (Capability)((Object)capability)));
    }

    public UpgradeSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(UpgradeSchema schema, String currentSlot) {
        this.currentSchema = schema;
        this.currentSlot = currentSlot;
        this.changeListeners.values().forEach(Runnable::run);
        this.sync();
    }

    public void clearSchema() {
        this.setCurrentSchema(null, null);
    }

    public void update(UpgradeSchema currentSchema, String currentSlot, PlayerEntity player) {
        if (currentSchema == null && player != null) {
            this.emptyMaterialSlots(player);
        }
        this.currentSchema = currentSchema;
        this.currentSlot = currentSlot;
        this.sync();
    }

    public String getCurrentSlot() {
        return this.currentSlot;
    }

    private void sync() {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new WorkbenchPacketUpdate(this.field_174879_c, this.currentSchema, this.currentSlot));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            this.func_70296_d();
        }
    }

    public ItemStack getTargetItemStack() {
        return (ItemStack)this.handler.map(handler -> {
            ItemStack stack = handler.getStackInSlot(0);
            ItemStack placeholder = ItemUpgradeRegistry.instance.getReplacement(stack);
            if (!placeholder.func_190926_b()) {
                return placeholder;
            }
            return stack;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    public ItemStack[] getMaterials() {
        return (ItemStack[])this.handler.map(handler -> {
            ItemStack[] result = new ItemStack[3];
            for (int i = 0; i < result.length; ++i) {
                result[i] = handler.getStackInSlot(i + 1).func_77946_l();
            }
            return result;
        }).orElse((Object)new ItemStack[0]);
    }

    public void initiateCrafting(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new WorkbenchPacketCraft(this.field_174879_c));
        }
        this.craft(player);
        this.sync();
    }

    public void craft(PlayerEntity player) {
        ItemStack targetStack;
        ItemStack upgradedStack = targetStack = this.getTargetItemStack();
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        int[] availableCapabilities = CapabilityHelper.getCombinedCapabilityLevels(player, this.func_145831_w(), this.func_174877_v(), blockState);
        ItemStack[] materials = this.getMaterials();
        ItemStack[] materialsAltered = (ItemStack[])Arrays.stream(this.getMaterials()).map(ItemStack::func_77946_l).toArray(ItemStack[]::new);
        if (this.currentSchema != null && this.currentSchema.canApplyUpgrade(player, targetStack, materialsAltered, this.currentSlot, availableCapabilities)) {
            float severity = this.currentSchema.getSeverity(targetStack, materialsAltered, this.currentSlot);
            upgradedStack = this.currentSchema.applyUpgrade(targetStack, materialsAltered, true, this.currentSlot, player);
            if (upgradedStack.func_77973_b() instanceof ItemModular) {
                ((ItemModular)upgradedStack.func_77973_b()).assemble(upgradedStack, this.field_145850_b, severity);
            }
            for (Capability capability : this.currentSchema.getRequiredCapabilities(targetStack, materials)) {
                int requiredLevel;
                ItemStack providingStack = CapabilityHelper.getProvidingItemStack(capability, requiredLevel = this.currentSchema.getRequiredCapabilityLevel(targetStack, materials, capability), (Entity)player);
                if (!providingStack.func_190926_b()) {
                    if (!(providingStack.func_77973_b() instanceof ItemModular)) continue;
                    upgradedStack = ((ItemModular)providingStack.func_77973_b()).onCraftConsumeCapability(providingStack, upgradedStack, player, capability, requiredLevel, true);
                    continue;
                }
                ItemStack consumeTarget = upgradedStack;
                upgradedStack = CastOptional.cast(this.func_195044_w().func_177230_c(), AbstractWorkbenchBlock.class).map(block -> block.onCraftConsumeCapability(this.field_145850_b, this.func_174877_v(), blockState, consumeTarget, player, true)).orElse(upgradedStack);
            }
            int xpCost = this.currentSchema.getExperienceCost(targetStack, materials, this.currentSlot);
            if (!player.func_184812_l_() && xpCost > 0) {
                player.func_82242_a(-xpCost);
            }
        }
        ItemStack tempStack = upgradedStack;
        this.handler.ifPresent(handler -> {
            for (int i = 0; i < materialsAltered.length; ++i) {
                handler.setStackInSlot(i + 1, materialsAltered[i]);
            }
            this.emptyMaterialSlots(player);
            handler.setStackInSlot(0, tempStack);
        });
        this.clearSchema();
    }

    public void applyTweaks(PlayerEntity player, String slot, Map<String, Integer> tweaks) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer(new WorkbenchPacketTweak(this.field_174879_c, slot, tweaks));
        }
        this.tweak(player, slot, tweaks);
        this.sync();
    }

    public void tweak(PlayerEntity player, String slot, Map<String, Integer> tweaks) {
        this.handler.ifPresent(handler -> {
            ItemStack tweakedStack = this.getTargetItemStack().func_77946_l();
            CastOptional.cast(tweakedStack.func_77973_b(), ItemModular.class).ifPresent(item -> item.tweak(tweakedStack, slot, tweaks));
            handler.setStackInSlot(0, tweakedStack);
        });
    }

    public void addChangeListener(String key, Runnable runnable) {
        this.changeListeners.put(key, runnable);
    }

    public void removeChangeListener(String key) {
        this.changeListeners.remove(key);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l(inventoryKey)));
        String schemaKey = compound.func_74779_i(schemaKey);
        this.currentSchema = ItemUpgradeRegistry.instance.getSchema(schemaKey);
        if (compound.func_74764_b(currentSlotKey)) {
            this.currentSlot = compound.func_74779_i(currentSlotKey);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.handler.ifPresent(handler -> compound.func_218657_a(inventoryKey, (INBT)handler.serializeNBT()));
        if (this.currentSchema != null) {
            compound.func_74778_a(schemaKey, this.currentSchema.getKey());
        }
        if (this.currentSlot != null) {
            compound.func_74778_a(currentSlotKey, this.currentSlot);
        }
        return compound;
    }

    private void emptyMaterialSlots(PlayerEntity player) {
        this.handler.ifPresent(handler -> {
            for (int i = 1; i < handler.getSlots(); ++i) {
                this.transferStackToPlayer(player, i);
            }
            this.func_70296_d();
        });
    }

    private void emptyMaterialSlots() {
        this.handler.ifPresent(handler -> {
            if (!this.field_145850_b.field_72995_K) {
                for (int i = 1; i < 4; ++i) {
                    ItemStack materialStack = handler.extractItem(i, handler.getSlotLimit(i), false);
                    if (materialStack.func_190926_b()) continue;
                    ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, materialStack);
                    itemEntity.func_174869_p();
                    this.field_145850_b.func_217376_c((Entity)itemEntity);
                }
            } else {
                for (int i = 1; i < 4; ++i) {
                    handler.extractItem(i, handler.getSlotLimit(i), false);
                }
            }
        });
    }

    private void transferStackToPlayer(PlayerEntity player, int index) {
        this.handler.ifPresent(handler -> {
            ItemStack itemStack = handler.extractItem(index, handler.getSlotLimit(index), false);
            if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
                player.func_71019_a(itemStack, false);
            }
        });
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(unlocalizedName);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new WorkbenchContainer(windowId, this, (IInventory)playerInventory, playerEntity);
    }

    static {
        defaultActions = new WorkbenchAction[]{new RepairAction()};
        actions = new WorkbenchAction[0];
        DataManager.actionData.onReload(() -> {
            Object[] configActions = (WorkbenchAction[])DataManager.actionData.getData().values().stream().flatMap(Arrays::stream).toArray(ConfigAction[]::new);
            actions = (WorkbenchAction[])ArrayUtils.addAll((Object[])defaultActions, (Object[])configActions);
        });
    }
}

