/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapabilityRequirement;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiTextures;

public class GuiActionButton
extends GuiElement {
    private WorkbenchAction action;
    private ItemStack targetStack;
    private GuiCapabilityRequirement capabilityIndicator;
    private GuiClickable iconClickable;
    private GuiClickable labelClickable;
    private GuiTexture borderLeft;
    private GuiTexture borderRight;
    private GuiRect borderTop;
    private GuiRect borderBottom;

    public GuiActionButton(int x, int y, WorkbenchAction action, ItemStack targetStack, Consumer<WorkbenchAction> clickHandler) {
        this(x, y, action, targetStack, GuiAlignment.left, clickHandler);
    }

    public GuiActionButton(int x, int y, WorkbenchAction action, ItemStack targetStack, GuiAlignment alignment, Consumer<WorkbenchAction> clickHandler) {
        super(x, y, 0, 11);
        this.action = action;
        this.targetStack = targetStack;
        String label = I18n.func_135052_a((String)(action.getKey() + ".label"), (Object[])new Object[0]);
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(label) + 42;
        this.labelClickable = new GuiClickable(0, 0, this.width, this.height, () -> clickHandler.accept(action)){

            protected void onFocus() {
                GuiActionButton.this.setBorderColors(0x8F8F6F);
            }

            protected void onBlur() {
                if (!GuiActionButton.this.iconClickable.hasFocus()) {
                    GuiActionButton.this.setBorderColors(0x7F7F7F);
                }
            }
        };
        this.labelClickable.addChild((GuiElement)new GuiRect(9, 0, this.width - 18, 11, 0));
        this.borderLeft = new GuiTexture(0, 0, 9, 11, 79, 0, GuiTextures.workbench).setColor(0x7F7F7F);
        this.labelClickable.addChild((GuiElement)this.borderLeft);
        this.borderRight = new GuiTexture(this.width - 9, 0, 9, 11, 88, 0, GuiTextures.workbench).setColor(0x7F7F7F);
        this.labelClickable.addChild((GuiElement)this.borderRight);
        this.borderTop = new GuiRect(9, 1, this.width - 18, 1, 0x7F7F7F);
        this.labelClickable.addChild((GuiElement)this.borderTop);
        this.borderBottom = new GuiRect(9, 9, this.width - 18, 1, 0x7F7F7F);
        this.labelClickable.addChild((GuiElement)this.borderBottom);
        GuiStringOutline labelString = new GuiStringOutline(7, 1, label);
        labelString.setAttachment(alignment.flip().toAttachment());
        if (GuiAlignment.left.equals((Object)alignment)) {
            labelString.setX(-labelString.getX());
        }
        this.labelClickable.addChild((GuiElement)labelString);
        this.addChild((GuiElement)this.labelClickable);
        this.iconClickable = new GuiClickable(6, -9, 29, 29, () -> clickHandler.accept(action)){

            protected void onFocus() {
                GuiActionButton.this.setBorderColors(0x8F8F6F);
            }

            protected void onBlur() {
                if (!GuiActionButton.this.labelClickable.hasFocus()) {
                    GuiActionButton.this.setBorderColors(0x7F7F7F);
                }
            }
        };
        this.iconClickable.setAttachment(alignment.toAttachment());
        if (GuiAlignment.right.equals((Object)alignment)) {
            this.iconClickable.setX(-this.iconClickable.getX());
        }
        this.iconClickable.addChild((GuiElement)new GuiTexture(0, 0, 29, 29, 97, 0, GuiTextures.workbench));
        this.addChild((GuiElement)this.iconClickable);
        Capability[] capabilities = action.getRequiredCapabilitiesFor(targetStack);
        this.capabilityIndicator = new GuiCapabilityRequirement(6, 7, capabilities.length > 0 ? capabilities[0] : Capability.hammer);
        this.iconClickable.addChild((GuiElement)this.capabilityIndicator);
    }

    private void setBorderColors(int color) {
        this.borderLeft.setColor(color);
        this.borderRight.setColor(color);
        this.borderTop.setColor(color);
        this.borderBottom.setColor(color);
    }

    public void update(int[] availableCapabilities) {
        Capability[] capabilities = this.action.getRequiredCapabilitiesFor(this.targetStack);
        if (capabilities.length > 0) {
            this.capabilityIndicator.updateRequirement(this.action.getCapabilityLevel(this.targetStack, capabilities[0]), availableCapabilities[capabilities[0].ordinal()]);
        }
    }
}

