/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.GuiTextSmall;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiMagicUsage;
import se.mickelus.tetra.gui.GuiSettleProgress;
import se.mickelus.tetra.gui.GuiSynergyIndicator;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.GlyphData;

public class GuiModuleDetails
extends GuiElement {
    private GuiElement glyph = new GuiElement(3, 3, 16, 16);
    private GuiString title;
    private GuiTextSmall description;
    private GuiString emptyLabel;
    private GuiMagicUsage magicBar;
    private GuiSettleProgress settleBar;
    private GuiSynergyIndicator synergyIndicator;
    private GuiElement repairGroup;
    private GuiStringSmall repairTitle;
    private GuiItemRolling repairMaterial;
    private GuiStringSmall noRepairLabel;

    public GuiModuleDetails(int x, int y) {
        super(x, y, 224, 67);
        this.addChild(this.glyph);
        this.title = new GuiString(20, 7, 105, "");
        this.addChild((GuiElement)this.title);
        this.description = new GuiTextSmall(5, 19, 105, "");
        this.addChild((GuiElement)this.description);
        this.emptyLabel = new GuiString(0, -3, TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"workbench.module_detail.empty", (Object[])new Object[0]));
        this.emptyLabel.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.emptyLabel);
        this.synergyIndicator = new GuiSynergyIndicator(130, 8);
        this.addChild(this.synergyIndicator);
        this.repairGroup = new GuiElement(150, 5, 60, 16);
        this.addChild(this.repairGroup);
        this.repairTitle = new GuiStringSmall(0, 7, I18n.func_135052_a((String)"item.tetra.modular.repair_material.label", (Object[])new Object[0]));
        this.repairGroup.addChild((GuiElement)this.repairTitle);
        this.noRepairLabel = new GuiStringSmall(0, 7, TextFormatting.GRAY + I18n.func_135052_a((String)"item.tetra.modular.repair_material.empty", (Object[])new Object[0]));
        this.noRepairLabel.setAttachment(GuiAttachment.topCenter);
        this.noRepairLabel.setVisible(false);
        this.repairGroup.addChild((GuiElement)this.noRepairLabel);
        this.repairMaterial = new GuiItemRolling(-2, 0);
        this.repairMaterial.setAttachment(GuiAttachment.topRight);
        this.repairGroup.addChild((GuiElement)this.repairMaterial);
        this.magicBar = new GuiMagicUsage(130, 30, 80);
        this.addChild(this.magicBar);
        this.settleBar = new GuiSettleProgress(130, 45, 80);
        this.addChild(this.settleBar);
    }

    public void update(ItemModule module, ItemStack itemStack) {
        this.glyph.clearChildren();
        if (module != null) {
            this.title.setString(module.getName(itemStack));
            this.description.setString(module.getDescription(itemStack));
            GlyphData glyphData = module.getVariantData((ItemStack)itemStack).glyph;
            if (module instanceof ItemModuleMajor) {
                this.glyph.addChild((GuiElement)new GuiTexture(0, 0, 15, 15, 52, 0, GuiTextures.workbench));
                this.glyph.addChild((GuiElement)new GuiModuleGlyph(-1, 0, 16, 16, glyphData).setShift(false));
                this.settleBar.update(itemStack, (ItemModuleMajor)module);
            } else {
                this.glyph.addChild((GuiElement)new GuiTexture(3, 2, 11, 11, 68, 0, GuiTextures.workbench));
                this.glyph.addChild((GuiElement)new GuiModuleGlyph(5, 4, 8, 8, glyphData).setShift(false));
            }
            this.magicBar.update(itemStack, ItemStack.field_190927_a, module.getSlot());
            this.synergyIndicator.update(itemStack, module);
            ItemStack[] repairItemStacks = (ItemStack[])RepairRegistry.instance.getDefinitions(module.getVariantData((ItemStack)itemStack).key).stream().map(definition -> definition.material.getApplicableItemStacks()).flatMap(Arrays::stream).toArray(ItemStack[]::new);
            this.repairMaterial.setItems(repairItemStacks);
            boolean canRepair = repairItemStacks.length > 0;
            this.repairTitle.setVisible(canRepair);
            this.repairMaterial.setVisible(canRepair);
            this.noRepairLabel.setVisible(!canRepair);
        }
        this.synergyIndicator.setVisible(module != null);
        this.title.setVisible(module != null);
        this.description.setVisible(module != null);
        this.settleBar.setVisible(module instanceof ItemModuleMajor);
        this.magicBar.setVisible(module instanceof ItemModuleMajor);
        this.emptyLabel.setVisible(module == null);
        this.repairGroup.setVisible(module != null);
    }
}

