/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;

public class GuiModuleImprovement
extends GuiElement {
    private final List<String> tooltipLines;
    private Runnable hoverHandler;
    private Runnable blurHandler;

    public GuiModuleImprovement(int x, int y, String improvement, int level, int color, Runnable hoverHandler, Runnable blurHandler) {
        super(x, y, 4, 4);
        this.addChild((GuiElement)new GuiRect(0, 1, this.width, 1, color));
        this.tooltipLines = new ArrayList<String>();
        if (level < 0) {
            this.tooltipLines.add(TextFormatting.DARK_RED + "-" + I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[]{""}));
        } else if (level == 0) {
            this.tooltipLines.add(I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[0]));
        } else {
            this.tooltipLines.add(I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]));
        }
        Arrays.stream(I18n.func_135052_a((String)(improvement + ".description"), (Object[])new Object[0]).split("\\\\n")).map(line -> line.replace(TextFormatting.RESET.toString(), TextFormatting.DARK_GRAY.toString())).map(line -> TextFormatting.DARK_GRAY + line).forEachOrdered(this.tooltipLines::add);
        this.hoverHandler = hoverHandler;
        this.blurHandler = blurHandler;
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltipLines;
        }
        return null;
    }

    protected void onFocus() {
        super.onFocus();
        this.hoverHandler.run();
    }

    protected void onBlur() {
        super.onBlur();
        this.blurHandler.run();
    }
}

