/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.GuiTextureOffset;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.gui.GuiModule;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleBackdrop;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleImprovement;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ImprovementData;

public class GuiModuleMajor
extends GuiModule {
    private GuiStringSmall slotString;
    private GuiModuleImprovement[] improvementElements;

    public GuiModuleMajor(int x, int y, GuiAttachment attachmentPoint, ItemStack itemStack, ItemStack previewStack, String slotKey, String slotName, ItemModuleMajor module, ItemModuleMajor previewModule, Consumer<String> slotClickHandler, BiConsumer<String, String> hoverHandler) {
        super(x, y, attachmentPoint, itemStack, previewStack, slotKey, slotName, module, previewModule, slotClickHandler, hoverHandler);
        this.height = 17;
        this.improvementElements = new GuiModuleImprovement[0];
        if (module != null && previewModule != null) {
            this.setupImprovements(previewModule, previewStack, module, itemStack);
        }
    }

    @Override
    public void showAnimation(int offset) {
        if (this.isVisible()) {
            int direction = this.attachmentPoint == GuiAttachment.topLeft ? -2 : 2;
            new KeyframeAnimation(100, (GuiElement)this.backdrop).withDelay(offset * 80).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)direction, 0.0f, true)}).start();
            if (this.glyph != null) {
                new KeyframeAnimation(100, (GuiElement)this.glyph).withDelay(offset * 80 + 100).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).start();
            }
            if (this.tweakingIndicator != null) {
                new KeyframeAnimation(100, (GuiElement)this.tweakingIndicator).withDelay(offset * 80 + 100).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).start();
            }
            new KeyframeAnimation(100, (GuiElement)this.moduleString).withDelay(offset * 80 + 200).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)(direction * 2), 0.0f, true)}).start();
            new KeyframeAnimation(100, (GuiElement)this.slotString).withDelay(offset * 80 + 100).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)(direction * 2), 0.0f, true)}).start();
            for (int i = 0; i < this.improvementElements.length; ++i) {
                new KeyframeAnimation(100, (GuiElement)this.improvementElements[i]).withDelay(offset * 200 + 280 + i * 80).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).start();
            }
        }
    }

    @Override
    protected void setupChildren(String moduleName, GlyphData glyphData, String slotName, boolean tweakable) {
        this.backdrop = new GuiModuleBackdrop(1, 0, 0xFFFFFF);
        this.backdrop.setAttachment(this.attachmentPoint);
        this.addChild((GuiElement)this.backdrop);
        if (tweakable) {
            this.tweakingIndicator = new GuiTextureOffset(1, 0, 15, 15, 96, 32, GuiTextures.workbench);
            this.tweakingIndicator.setAttachment(this.attachmentPoint);
            this.addChild((GuiElement)this.tweakingIndicator);
        }
        this.moduleString = new GuiString(19, 5, "");
        if (moduleName != null) {
            this.moduleString.setString(moduleName);
        } else {
            this.moduleString.setString(I18n.func_135052_a((String)"item.tetra.modular.empty_slot", (Object[])new Object[0]));
        }
        if (GuiAttachment.topRight.equals((Object)this.attachmentPoint)) {
            this.moduleString.setX(-16);
        }
        this.moduleString.setAttachment(this.attachmentPoint);
        this.addChild((GuiElement)this.moduleString);
        this.slotString = new GuiStringSmall(19, 0, slotName);
        if (GuiAttachment.topRight.equals((Object)this.attachmentPoint)) {
            this.slotString.setX(-16);
        }
        this.slotString.setAttachment(this.attachmentPoint);
        this.addChild((GuiElement)this.slotString);
        this.width = this.moduleString.getWidth() + 19;
        if (glyphData != null) {
            this.glyph = new GuiModuleGlyph(0, 0, 16, 16, glyphData.tint, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
            if (GuiAttachment.topRight.equals((Object)this.attachmentPoint)) {
                this.glyph.setX(1);
            }
            this.glyph.setAttachment(this.attachmentPoint);
            this.addChild(this.glyph);
        }
    }

    private void setupImprovements(ItemModuleMajor previewModule, ItemStack previewStack, ItemModuleMajor module, ItemStack itemStack) {
        String[] improvements = GuiModuleMajor.getImprovementUnion(module.getImprovements(itemStack), previewModule.getImprovements(previewStack));
        this.improvementElements = new GuiModuleImprovement[improvements.length];
        for (int i = 0; i < improvements.length; ++i) {
            String improvementKey = improvements[i];
            int currentValue = module.getImprovementLevel(itemStack, improvements[i]);
            int previewValue = previewModule.getImprovementLevel(previewStack, improvements[i]);
            int color = currentValue == -1 ? 0xAAFFAA : (previewValue == -1 ? 0xFFAAAA : (currentValue != previewValue ? 0xAAAAFF : module.getImprovement((ItemStack)itemStack, (String)improvementKey).glyph.tint));
            this.improvementElements[i] = GuiAttachment.topRight.equals((Object)this.attachmentPoint) ? new GuiModuleImprovement(-17 + i * -5, 13, improvements[i], previewValue, color, () -> this.hoverHandler.accept(this.slotKey, improvementKey), () -> {
                if (this.hasFocus()) {
                    this.hoverHandler.accept(this.slotKey, null);
                }
            }) : new GuiModuleImprovement(19 + i * 5, 13, improvements[i], previewValue, color, () -> this.hoverHandler.accept(this.slotKey, improvementKey), () -> {
                if (this.hasFocus()) {
                    this.hoverHandler.accept(this.slotKey, null);
                }
            });
            this.improvementElements[i].setAttachment(this.attachmentPoint);
            this.addChild(this.improvementElements[i]);
        }
    }

    public static String[] getImprovementUnion(ImprovementData[] improvements, ImprovementData[] previewImprovements) {
        return (String[])Stream.concat(Arrays.stream(improvements), Arrays.stream(previewImprovements)).map(improvement -> improvement.key).distinct().toArray(String[]::new);
    }

    @Override
    protected void setColor(int color) {
        super.setColor(color);
        this.slotString.setColor(color);
        if (0x7F7F7F == color) {
            Arrays.stream(this.improvementElements).forEach(element -> element.setOpacity(0.5f));
        } else {
            Arrays.stream(this.improvementElements).forEach(element -> element.setOpacity(1.0f));
        }
    }
}

