/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.SchemaRarity;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiSchemaListItem
extends GuiClickable {
    private GuiTexture border;
    private GuiTexture glyph;
    private GuiString label;
    private SchemaRarity rarity;

    public GuiSchemaListItem(int x, int y, UpgradeSchema schema, Runnable onClickHandler) {
        this(x, y, 109, schema, onClickHandler);
    }

    public GuiSchemaListItem(int x, int y, int width, UpgradeSchema schema, Runnable onClickHandler) {
        super(x, y, width, 14, onClickHandler);
        this.rarity = schema.getRarity();
        this.label = new GuiString(16, 3, width - 16, schema.getName());
        this.label.setColor(this.rarity.tint);
        this.addChild((GuiElement)this.label);
        GlyphData glyphData = schema.getGlyph();
        if (schema.getType() == SchemaType.major) {
            this.border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            this.glyph = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schema.getType() == SchemaType.minor) {
            this.border = new GuiTexture(2, 1, 11, 11, 68, 0, GuiTextures.workbench);
            this.glyph = new GuiTexture(4, 3, 8, 8, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schema.getType() == SchemaType.improvement) {
            this.border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            this.glyph = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schema.getType() == SchemaType.other) {
            this.glyph = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        }
        if (this.border != null) {
            this.border.setOpacity(0.3f);
            this.border.setColor(this.rarity.tint);
            this.addChild((GuiElement)this.border);
        }
        this.glyph.setColor(this.rarity.tint);
        this.addChild((GuiElement)this.glyph);
        if (schema.getType() == SchemaType.improvement) {
            this.addChild((GuiElement)new GuiTexture(7, 7, 7, 7, 68, 16, GuiTextures.workbench));
        }
    }

    protected void onFocus() {
        if (this.border != null) {
            this.border.setOpacity(0.6f);
        }
        this.label.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        if (this.border != null) {
            this.border.setOpacity(0.3f);
        }
        this.label.setColor(this.rarity.tint);
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus() && this.rarity.equals((Object)SchemaRarity.temporary)) {
            return Collections.singletonList(I18n.func_135052_a((String)"workbench.schema_list.temporary", (Object[])new Object[0]));
        }
        return null;
    }
}

