/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleDetails;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchemaDetail;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchemaList;
import se.mickelus.tetra.blocks.workbench.gui.GuiSlotTabGroup;
import se.mickelus.tetra.blocks.workbench.gui.GuiTweakControls;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

public class GuiSlotDetail
extends GuiElement {
    private int tab = 1;
    private GuiSlotTabGroup tabGroup;
    private GuiModuleDetails moduleDetails;
    private GuiElement schemaGroup;
    private GuiSchemaList schemaList;
    private GuiSchemaDetail schemaDetail;
    private GuiTweakControls tweakControls;
    private Consumer<UpgradeSchema> selectSchemaHandler;
    private final AnimationChain slotTransition;

    public GuiSlotDetail(int x, int y, Consumer<UpgradeSchema> selectSchemaHandler, Runnable closeHandler, Runnable craftHandler, Consumer<Map<String, Integer>> previewTweak, Consumer<Map<String, Integer>> applyTweak) {
        super(x, y, 224, 67);
        this.selectSchemaHandler = selectSchemaHandler;
        this.addChild((GuiElement)new GuiTexture(0, 0, this.width, this.height, 0, 68, GuiTextures.workbench));
        this.addChild((GuiElement)new GuiRect(1, 6, 2, 49, 0));
        this.tabGroup = new GuiSlotTabGroup(1, 6, this::changeTab);
        this.tabGroup.setHasContent(1, true);
        this.addChild(this.tabGroup);
        this.moduleDetails = new GuiModuleDetails(0, 0);
        this.addChild(this.moduleDetails);
        this.schemaGroup = new GuiElement(0, 0, this.width, this.height);
        this.addChild(this.schemaGroup);
        this.schemaList = new GuiSchemaList(0, 0, selectSchemaHandler);
        this.schemaList.setVisible(false);
        this.schemaGroup.addChild((GuiElement)this.schemaList);
        this.schemaDetail = new GuiSchemaDetail(0, 0, () -> selectSchemaHandler.accept(null), craftHandler);
        this.schemaDetail.setVisible(false);
        this.schemaGroup.addChild((GuiElement)this.schemaDetail);
        this.tweakControls = new GuiTweakControls(0, 0, previewTweak, applyTweak);
        this.addChild(this.tweakControls);
        GuiRect slotTransitionElement = new GuiRect(3, 3, 218, 56, 0);
        slotTransitionElement.setOpacity(0.0f);
        this.addChild((GuiElement)slotTransitionElement);
        this.slotTransition = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(60, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.3f)}), new KeyframeAnimation(100, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        GuiButton buttonClose = new GuiButton(215, -4, "x", closeHandler);
        this.addChild((GuiElement)buttonClose);
        this.setVisible(false);
    }

    private void changeTab(int index) {
        this.selectSchemaHandler.accept(null);
        this.tab = index;
        this.updateTabVisibility();
        this.slotTransition.stop();
        this.slotTransition.start();
    }

    private void updateTabVisibility() {
        this.moduleDetails.setVisible(this.tab == 0);
        this.schemaGroup.setVisible(this.tab == 1);
        this.tweakControls.setVisible(this.tab == 2);
    }

    public void onTileEntityChange(PlayerEntity player, WorkbenchTile tileEntity, ItemStack itemStack, String selectedSlot, UpgradeSchema currentSchema) {
        ItemModule module = CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(itemStack, selectedSlot)).orElse(null);
        if (currentSchema == null) {
            this.updateSchemaList(player, tileEntity, selectedSlot);
        } else {
            World world = tileEntity.func_145831_w();
            BlockPos pos = tileEntity.func_174877_v();
            int[] availableCapabilities = CapabilityHelper.getCombinedCapabilityLevels(player, world, pos, world.func_180495_p(pos));
            ItemStack[] materials = tileEntity.getMaterials();
            this.schemaDetail.update(currentSchema, itemStack, selectedSlot, materials, availableCapabilities, player.func_184812_l_() ? Integer.MAX_VALUE : player.field_71068_ca);
            this.schemaDetail.updateMagicCapacity(currentSchema, selectedSlot, itemStack, currentSchema.applyUpgrade(itemStack.func_77946_l(), materials, false, selectedSlot, player));
            this.schemaDetail.toggleButton(currentSchema.canApplyUpgrade(player, itemStack, materials, selectedSlot, availableCapabilities));
            this.tab = 1;
        }
        this.moduleDetails.update(module, itemStack);
        this.tabGroup.setHasContent(0, module != null);
        this.tweakControls.update(module, itemStack);
        this.tabGroup.setHasContent(2, module != null && module.isTweakable(itemStack));
        this.schemaDetail.setVisible(currentSchema != null);
        this.schemaList.setVisible(currentSchema == null);
        this.updateTabVisibility();
        this.tabGroup.setActive(this.tab);
    }

    public void update(PlayerEntity player, WorkbenchTile tileEntity, int[] availableCapabilities) {
        this.schemaDetail.updateAvailableCapabilities(availableCapabilities);
        this.schemaDetail.toggleButton(tileEntity.getCurrentSchema().canApplyUpgrade(player, tileEntity.getTargetItemStack(), tileEntity.getMaterials(), tileEntity.getCurrentSlot(), availableCapabilities));
    }

    public void updatePreview(UpgradeSchema schema, String slot, ItemStack itemStack, ItemStack previewStack) {
        this.schemaDetail.updateMagicCapacity(schema, slot, itemStack, previewStack);
    }

    private void updateSchemaList(PlayerEntity player, WorkbenchTile tileEntity, String selectedSlot) {
        ItemStack targetStack = tileEntity.getTargetItemStack();
        UpgradeSchema[] schemas = ItemUpgradeRegistry.instance.getAvailableSchemas(player, targetStack);
        schemas = (UpgradeSchema[])Arrays.stream(schemas).filter(upgradeSchema -> upgradeSchema.isApplicableForSlot(selectedSlot, targetStack)).sorted(Comparator.comparing(UpgradeSchema::getRarity).thenComparing(UpgradeSchema::getType).thenComparing(UpgradeSchema::getKey)).toArray(UpgradeSchema[]::new);
        this.schemaList.setSchemas(schemas);
    }

    public void keyTyped(char typedChar) {
        this.tabGroup.keyTyped(typedChar);
    }
}

