/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.capabilities;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.util.CastOptional;

public class CapabilityHelper {
    public static int getItemCapabilityLevel(ItemStack itemStack, Capability capability) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof ICapabilityProvider).map(stack -> ((ICapabilityProvider)stack.func_77973_b()).getCapabilityLevel((ItemStack)stack, capability)).orElse(0);
    }

    public static Collection<Capability> getItemCapabilities(ItemStack itemStack) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof ICapabilityProvider).map(stack -> ((ICapabilityProvider)stack.func_77973_b()).getCapabilities((ItemStack)stack)).orElse(Collections.emptyList());
    }

    public static int getPlayerEffectLevel(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).map(itemStack -> ((ItemModular)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect)).max(Integer::compare).orElse(0);
    }

    public static double getPlayerEffectEfficiency(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).max(Comparator.comparingInt(itemStack -> ((ItemModular)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect))).map(itemStack -> ((ItemModular)itemStack.func_77973_b()).getEffectEfficiency((ItemStack)itemStack, effect)).orElse(0.0);
    }

    public static int getPlayerCapabilityLevel(PlayerEntity player, Capability capability) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).map(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability)).max(Integer::compare).orElse(0);
    }

    public static Collection<Capability> getPlayerCapabilities(PlayerEntity player) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).flatMap(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilities((ItemStack)itemStack).stream()).collect(Collectors.toSet());
    }

    private static ItemStack getReplacement(ItemStack itemStack) {
        ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(itemStack);
        if (!replacement.func_190926_b()) {
            return replacement;
        }
        return itemStack;
    }

    public static int getBlockCapabilityLevel(World world, BlockPos pos, BlockState blockStateIn, Capability capability) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getCapabilityLevel(world, pos, blockStateIn, capability)).orElse(-1);
    }

    public static Collection<Capability> getBlockCapabilities(World world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getCapabilities(world, pos, blockStateIn)).orElse(Collections.emptyList());
    }

    public static int getCombinedCapabilityLevel(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn, Capability capability) {
        return Math.max(CapabilityHelper.getPlayerCapabilityLevel(player, capability), CapabilityHelper.getBlockCapabilityLevel(world, pos, blockStateIn, capability));
    }

    public static int[] getCombinedCapabilityLevels(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn) {
        return Arrays.stream(Capability.values()).mapToInt(capability -> CapabilityHelper.getCombinedCapabilityLevel(player, world, pos, blockStateIn, capability)).toArray();
    }

    public static ItemStack getProvidingItemStack(Capability capability, int level, Entity entity) {
        return CastOptional.cast(entity, PlayerEntity.class).map(player -> Stream.concat(Stream.of(player.func_184614_ca(), player.func_184592_cb()), player.field_71071_by.field_70462_a.stream())).orElse(Stream.empty()).filter(itemStack -> !itemStack.func_190926_b()).map(CapabilityHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof ICapabilityProvider).filter(itemStack -> ((ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel((ItemStack)itemStack, capability) >= level).findAny().orElse(ItemStack.field_190927_a);
    }
}

