/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import se.mickelus.tetra.module.data.ModuleModel;

public final class ModularItemModel
implements IUnbakedModel {
    private final List<ModuleModel> models;

    public ModularItemModel(List<ModuleModel> models) {
        this.models = models;
    }

    private static ImmutableList<ResourceLocation> getTextures(BlockModel model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.func_178300_b("layer" + i)) {
            builder.add((Object)new ResourceLocation(model.func_178308_c("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return this.models.stream().map(model -> model.location).collect(Collectors.toList());
    }

    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    public ModularItemModel retexture(ImmutableMap<String, String> textures) {
        return new ModularItemModel(this.models);
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional transform = sprite.getState().apply(Optional.empty());
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)sprite.getState());
        boolean identity = !transform.isPresent() || ((TRSRTransformation)transform.get()).isIdentity();
        for (int i = 0; i < this.models.size(); ++i) {
            ModuleModel model = this.models.get(i);
            TextureAtlasSprite tas = spriteGetter.apply(model.location);
            builder.addAll(ModularItemModel.getQuadsForSprite(i, tas, format, transform, model.tint));
        }
        TextureAtlasSprite particle = spriteGetter.apply(this.models.isEmpty() ? new ResourceLocation("missingno") : this.models.get((int)0).location);
        return new BakedItemModel(builder.build(), particle, map, ItemOverrideList.field_188022_a, identity);
    }

    public static List<BakedQuad> getQuadsForSprite(int tintIndex, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform, int color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        for (int v = 0; v < vMax; ++v) {
            builder.add((Object)ModularItemModel.buildSideQuad(format, transform, Direction.UP, tintIndex, color, sprite, 0, v, uMax));
            builder.add((Object)ModularItemModel.buildSideQuad(format, transform, Direction.DOWN, tintIndex, color, sprite, 0, v + 1, uMax));
        }
        for (int u = 0; u < uMax; ++u) {
            builder.add((Object)ModularItemModel.buildSideQuad(format, transform, Direction.EAST, tintIndex, color, sprite, u + 1, 0, vMax));
            builder.add((Object)ModularItemModel.buildSideQuad(format, transform, Direction.WEST, tintIndex, color, sprite, u, 0, vMax));
        }
        builder.add((Object)ModularItemModel.buildQuad(format, transform, Direction.NORTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)ModularItemModel.buildQuad(format, transform, Direction.SOUTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        return builder.build();
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, Direction side, int tintIndex, int color, TextureAtlasSprite sprite, int u, int v, int size) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                x1 = (float)(u + size) / (float)width;
                break;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return ModularItemModel.buildQuad(format, transform, ModularItemModel.remap(side), sprite, tintIndex, color, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static Direction remap(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y ? side.func_176734_d() : side;
    }

    private static BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, Direction side, TextureAtlasSprite sprite, int tintIndex, int color, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tintIndex);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        boolean hasTransform = transform.isPresent() && !transform.get().isIdentity();
        UnpackedBakedQuad.Builder consumer = hasTransform ? new TRSRTransformer((IVertexConsumer)builder, transform.get()) : builder;
        ModularItemModel.putVertex((IVertexConsumer)consumer, format, side, x0, y0, z0, u0, v0, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, format, side, x1, y1, z1, u1, v1, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, format, side, x2, y2, z2, u2, v2, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, format, side, x3, y3, z3, u3, v3, color);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, VertexFormat format, Direction side, float x, float y, float z, float u, float v, int color) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    consumer.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    a = a == 0.0f ? 1.0f : a;
                    consumer.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case NORMAL: {
                    float offX = side.func_82601_c();
                    float offY = side.func_96559_d();
                    float offZ = side.func_82599_e();
                    consumer.put(e, new float[]{offX, offY, offZ, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

