/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.BakedWrapper;
import se.mickelus.tetra.client.model.ModularOverrideList;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModular;

public class ModularModelLoader {
    private static final Logger logger = LogManager.getLogger();
    private static List<ItemModular> items = new ArrayList<ItemModular>();
    private static List<ModularOverrideList> overrides = new ArrayList<ModularOverrideList>();

    public static void registerItem(ItemModular item) {
        items.add(item);
    }

    public static void loadModels(ModelBakeEvent event) {
        overrides.clear();
        items.forEach(item -> {
            ModelResourceLocation resourceLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
            SimpleBakedModel originalModel = (SimpleBakedModel)event.getModelRegistry().get(resourceLocation);
            try {
                IBakedModel model = ModularModelLoader.loadModel(event.getModelLoader(), originalModel, resourceLocation);
                event.getModelRegistry().put(resourceLocation, model);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        });
    }

    private static IBakedModel loadModel(ModelLoader modelLoader, SimpleBakedModel originalModel, ModelResourceLocation location) throws Exception {
        BlockModel unbakedModel = (BlockModel)modelLoader.func_209597_a((ResourceLocation)location);
        ModularOverrideList override = new ModularOverrideList((ModelBakery)modelLoader, unbakedModel);
        overrides.add(override);
        return new BakedWrapper(originalModel, override);
    }

    public static void clearCaches() {
        logger.info("Clearing item model cache, let's get bakin'");
        overrides.forEach(ModularOverrideList::clearCache);
    }

    static {
        DataManager.moduleData.onReload(ModularModelLoader::clearCaches);
    }
}

