/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.client.model.ModularItemModel;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.data.ModuleModel;

public class ModularOverrideList
extends ItemOverrideList {
    private Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final ModelBakery bakery;
    private final BlockModel unbaked;

    public ModularOverrideList(ModelBakery bakery, BlockModel unbaked) {
        this.bakery = bakery;
        this.unbaked = unbaked;
    }

    public void clearCache() {
        this.bakedModelCache.invalidateAll();
    }

    @Nullable
    public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        CompoundNBT baseTag = NBTHelper.getTag(stack);
        IBakedModel result = originalModel;
        if (!baseTag.isEmpty()) {
            CacheKey key = this.getCacheKey(stack, entity, originalModel);
            try {
                result = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, entity));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected CacheKey getCacheKey(ItemStack itemStack, LivingEntity entity, IBakedModel original) {
        return new CacheKey(original, ((ItemModular)itemStack.func_77973_b()).getModelCacheKey(itemStack, entity));
    }

    protected IBakedModel getOverrideModel(ItemStack itemStack, @Nullable LivingEntity entity) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        ItemCameraTransforms transforms = this.unbaked.func_181682_g();
        HashMap tMap = Maps.newHashMap();
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
        ImmutableList<ModuleModel> models = item.getModels(itemStack, entity);
        return new ModularItemModel((List<ModuleModel>)models).bake(this.bakery, ModelLoader.defaultTextureGetter(), (ISprite)perState, DefaultVertexFormats.field_176599_b);
    }

    protected static class CacheKey {
        final IBakedModel parent;
        final String data;

        protected CacheKey(IBakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

