/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.workbench.action.ConfigActionImpl;
import se.mickelus.tetra.data.DataStore;
import se.mickelus.tetra.data.FeatureStore;
import se.mickelus.tetra.data.ModuleStore;
import se.mickelus.tetra.data.SchemaStore;
import se.mickelus.tetra.data.deserializer.BlockDeserializer;
import se.mickelus.tetra.data.deserializer.BlockPosDeserializer;
import se.mickelus.tetra.data.deserializer.EnchantmentDeserializer;
import se.mickelus.tetra.data.deserializer.GlyphDeserializer;
import se.mickelus.tetra.data.deserializer.ItemDeserializer;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;
import se.mickelus.tetra.data.deserializer.ModuleModelDeserializer;
import se.mickelus.tetra.data.deserializer.PropertyMatcherDeserializer;
import se.mickelus.tetra.data.deserializer.ReplacementDeserializer;
import se.mickelus.tetra.data.deserializer.ResourceLocationDeserializer;
import se.mickelus.tetra.generation.FeatureParameters;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.data.CapabilityData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.schema.Material;
import se.mickelus.tetra.module.schema.RepairDefinition;

public class DataManager {
    private Logger logger = LogManager.getLogger();
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(CapabilityData.class, (Object)new CapabilityData.Deserializer()).registerTypeAdapter(EffectData.class, (Object)new EffectData.Deserializer()).registerTypeAdapter(GlyphData.class, (Object)new GlyphDeserializer()).registerTypeAdapter(ModuleModel.class, (Object)new ModuleModelDeserializer()).registerTypeAdapter(Priority.class, (Object)new Priority.PriorityAdapter()).registerTypeAdapter(ItemPredicate.class, (Object)new ItemPredicateDeserializer()).registerTypeAdapter(PropertyMatcher.class, (Object)new PropertyMatcherDeserializer()).registerTypeAdapter(Material.class, (Object)new Material.MaterialDeserializer()).registerTypeAdapter(ReplacementDefinition.class, (Object)new ReplacementDeserializer()).registerTypeAdapter(BlockPos.class, (Object)new BlockPosDeserializer()).registerTypeAdapter(Block.class, (Object)new BlockDeserializer()).registerTypeAdapter(Item.class, (Object)new ItemDeserializer()).registerTypeAdapter(Enchantment.class, (Object)new EnchantmentDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationDeserializer()).registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(ILootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeAdapter(ILootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    public static DataStore<TweakData[]> tweakData = new DataStore<TweakData[]>(gson, "tweaks", TweakData[].class);
    public static DataStore<ImprovementData[]> improvementData = new DataStore<ImprovementData[]>(gson, "improvements", ImprovementData[].class);
    public static DataStore<ModuleData> moduleData = new ModuleStore(gson, "modules");
    public static DataStore<RepairDefinition> repairData = new DataStore<RepairDefinition>(gson, "repairs", RepairDefinition.class);
    public static DataStore<EnchantmentMapping[]> enchantmentData = new DataStore<EnchantmentMapping[]>(gson, "enchantments", EnchantmentMapping[].class);
    public static DataStore<SynergyData[]> synergyData = new DataStore<SynergyData[]>(gson, "synergies", SynergyData[].class);
    public static DataStore<ReplacementDefinition[]> replacementData = new DataStore<ReplacementDefinition[]>(gson, "replacements", ReplacementDefinition[].class);
    public static SchemaStore schemaData = new SchemaStore(gson, "schemas");
    public static DataStore<ItemPredicate[]> predicateData = new DataStore<ItemPredicate[]>(gson, "predicates", ItemPredicate[].class);
    public static DataStore<ConfigActionImpl[]> actionData = new DataStore<ConfigActionImpl[]>(gson, "actions", ConfigActionImpl[].class);
    public static DataStore<DestabilizationEffect[]> destabilizationData = new DataStore<DestabilizationEffect[]>(gson, "destabilization", DestabilizationEffect[].class);
    public static DataStore<FeatureParameters> featureData = new FeatureStore(gson, "structures");
    private DataStore[] dataStores = new DataStore[]{tweakData, improvementData, moduleData, enchantmentData, synergyData, replacementData, schemaData, repairData, predicateData, actionData, destabilizationData, featureData};
    public static DataManager instance;

    public DataManager() {
        instance = this;
    }

    @SubscribeEvent
    public void serverStarting(FMLServerAboutToStartEvent event) {
        this.logger.info("Setting up data reload listeners");
        for (DataStore dataStore : this.dataStores) {
            event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)dataStore);
        }
    }

    @SubscribeEvent
    public void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        this.logger.info("Sending data to client: {}", (Object)event.getPlayer().func_200200_C_().func_150254_d());
        for (DataStore dataStore : this.dataStores) {
            dataStore.sendToPlayer((ServerPlayerEntity)event.getPlayer());
        }
    }

    public void onDataRecieved(String directory, Map<ResourceLocation, String> data) {
        Arrays.stream(this.dataStores).filter(dataStore -> dataStore.getDirectory().equals(directory)).forEach(dataStore -> dataStore.loadFromPacket(data));
    }

    public SynergyData[] getSynergyData(String path) {
        SynergyData[] data;
        for (SynergyData entry : data = synergyData.getData(new ResourceLocation("tetra", path))) {
            Arrays.sort(entry.moduleVariants);
            Arrays.sort(entry.modules);
        }
        return data;
    }
}

