/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureChild;
import se.mickelus.tetra.generation.FeatureLoot;
import se.mickelus.tetra.generation.FeatureParameters;

@OnlyIn(value=Dist.CLIENT)
public class ExtendedStructureTESR
extends StructureTileEntityRenderer {
    public void func_199341_a(StructureBlockTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        super.func_199341_a(te, x, y, z, partialTicks, destroyStage);
        BlockPos rel = te.func_189711_e();
        Optional.ofNullable(DataManager.featureData.getData(new ResourceLocation(te.func_189715_d()))).ifPresent(feature -> this.renderFeatureInfo((FeatureParameters)feature, x + (double)rel.func_177958_n(), y + (double)rel.func_177956_o(), z + (double)rel.func_177952_p()));
    }

    private void renderFeatureInfo(FeatureParameters feature, double x, double y, double z) {
        GlStateManager.disableFog();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.func_190053_a(true);
        GlStateManager.lineWidth((float)3.0f);
        BlockPos origin = feature.origin;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5, x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_186662_g(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        Arrays.stream(feature.children).forEach(featureChild -> this.renderChild((FeatureChild)featureChild, x, y, z));
        Arrays.stream(feature.loot).forEach(featureLoot -> this.renderLoot((FeatureLoot)featureLoot, x, y, z));
        GlStateManager.lineWidth((float)1.0f);
        this.func_190053_a(false);
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.enableFog();
    }

    private void renderChild(FeatureChild featureChild, double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        BlockPos offset = featureChild.offset;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5, x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_186662_g(0.5020000000949949), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vec3i facing = featureChild.facing.func_176730_m();
        bufferBuilder.func_181662_b(x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(x + (double)offset.func_177958_n() + 0.5 + 0.3 * (double)facing.func_177958_n(), y + (double)offset.func_177956_o() + 0.5 + 0.3 * (double)facing.func_177956_o(), z + (double)offset.func_177952_p() + 0.5 + 0.3 * (double)facing.func_177952_p()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.8f);
    }

    private void renderLoot(FeatureLoot featureLoot, double x, double y, double z) {
        BlockPos offset = featureLoot.position;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)offset.func_177958_n(), y + (double)offset.func_177956_o(), z + (double)offset.func_177952_p(), x + (double)offset.func_177958_n() + 0.2, y + (double)offset.func_177956_o() + 0.2, z + (double)offset.func_177952_p() + 0.2).func_72317_d(-0.1, -0.1, -0.1);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }
}

