/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.RotationHelper;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureParameters;
import se.mickelus.tetra.generation.FeatureReference;
import se.mickelus.tetra.generation.processing.ForgedContainerProcessor;
import se.mickelus.tetra.generation.processing.ForgedCrateProcessor;
import se.mickelus.tetra.generation.processing.ForgedHammerProcessor;
import se.mickelus.tetra.generation.processing.TransferUnitProcessor;
import se.mickelus.tetra.util.ItemHandlerWrapper;

public class FeatureEntry
extends Feature<FeatureReference> {
    public static final String key = "feature";
    @ObjectHolder(value="tetra:feature")
    public static FeatureEntry instance;
    private TemplateManager templateManager;

    public FeatureEntry() {
        super(FeatureReference::deserialize);
        if (((Boolean)ConfigHandler.generateFeatures.get()).booleanValue()) {
            DataManager.featureData.onReload(this::addToBiomes);
        }
        this.setRegistryName("tetra", key);
    }

    public void setup(MinecraftServer server) {
        this.templateManager = new TemplateManager(server, server.func_71238_n(), server.func_195563_aC());
    }

    private void addToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222737_a.equals((Object)this));
        }
        DataManager.featureData.getData().values().stream().filter(params -> params.biomes.length > 0).forEach(params -> StreamSupport.stream(ForgeRegistries.BIOMES.spliterator(), false).filter(biome -> {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            return types.stream().anyMatch(type -> Arrays.stream(params.biomes).anyMatch(biomeName -> biomeName.equalsIgnoreCase(type.getName())));
        }).forEach(biome -> biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a((Feature)instance, (IFeatureConfig)new FeatureReference(params.location), (Placement)Placement.field_215032_r, (IPlacementConfig)new ChanceRangeConfig(1.0f, params.minY, params.minY, params.maxY)))));
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, FeatureReference ref) {
        FeatureParameters params = DataManager.featureData.getData(ref.location);
        ResourceLocation dimensionType = world.func_201675_m().func_186058_p().getRegistryName();
        if (params != null && Arrays.asList(params.dimensions).contains(dimensionType) && rand.nextFloat() < params.probability) {
            this.generateFeatureRoot(params, world, pos, rand);
            return true;
        }
        return false;
    }

    public void generateFeatureRoot(FeatureParameters feature, IWorld world, BlockPos pos, Random random) {
        Rotation rotation = Rotation.NONE;
        Mirror mirror = Mirror.NONE;
        if (feature.transform) {
            rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        }
        this.generateFeature(feature, world, pos, rotation, mirror, random, 0);
    }

    private void generateFeature(FeatureParameters feature, IWorld world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Template template = this.templateManager.func_200219_b(feature.location);
        if (template != null) {
            PlacementSettings settings = new PlacementSettings();
            settings.func_186220_a(rotation);
            if (depth == 0) {
                pos = template.func_189961_a(pos, mirror, rotation);
            }
            if (feature.integrityMin < 1.0f) {
                settings.func_215222_a((StructureProcessor)new IntegrityProcessor(random.nextFloat() * (feature.integrityMax - feature.integrityMin) + feature.integrityMin));
            }
            settings.func_215222_a((StructureProcessor)new ForgedContainerProcessor());
            settings.func_215222_a((StructureProcessor)new ForgedCrateProcessor());
            settings.func_215222_a((StructureProcessor)new ForgedHammerProcessor());
            settings.func_215222_a((StructureProcessor)new TransferUnitProcessor());
            boolean blocksAdded = template.func_189962_a(world, pos, settings, 2);
            if (blocksAdded) {
                this.generateLoot(feature, world, pos, settings, random);
            }
            if (depth < (Integer)ConfigHandler.maxFeatureDepth.get()) {
                this.generateChildren(feature, world, pos, rotation, mirror, random, depth);
            }
        }
    }

    private void generateChildren(FeatureParameters feature, IWorld world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Arrays.stream(feature.children).filter(child -> child.chance == 1.0f || random.nextFloat() < child.chance).forEach(child -> {
            ResourceLocation selectedLocation = child.features[random.nextInt(child.features.length)];
            FeatureParameters selectedFeature = DataManager.featureData.getData(selectedLocation);
            if (selectedFeature != null) {
                Rotation childRotation = rotation.func_185830_a(RotationHelper.rotationFromFacing(child.facing));
                PlacementSettings offsetPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation);
                PlacementSettings originPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(childRotation);
                BlockPos childPos = Template.func_186266_a((PlacementSettings)offsetPlacement, (BlockPos)child.offset).func_177973_b((Vec3i)Template.func_186266_a((PlacementSettings)originPlacement, (BlockPos)selectedFeature.origin)).func_177971_a((Vec3i)pos);
                this.generateFeature(selectedFeature, world, childPos, childRotation, mirror, random, depth + 1);
            }
        });
    }

    private BlockPos adjustRootPosition(Template template, BlockPos blockPos, Rotation rotation) {
        BlockPos size = template.func_186259_a();
        size = size.func_190942_a(rotation);
        BlockPos offset = new BlockPos(16 - Math.abs(size.func_177958_n()) / 2, 0, 16 - Math.abs(size.func_177952_p()) / 2);
        return blockPos.func_177971_a((Vec3i)offset);
    }

    private void generateLoot(FeatureParameters feature, IWorld world, BlockPos pos, PlacementSettings settings, Random random) {
        Arrays.stream(feature.loot).forEach(loot -> this.addLoot(loot.table, world, Template.func_186266_a((PlacementSettings)settings, (BlockPos)loot.position).func_177971_a((Vec3i)pos), random));
    }

    private void addLoot(ResourceLocation lootLocation, IWorld world, BlockPos pos, Random random) {
        ServerWorld serverWorld;
        TileEntity tileEntity = world.func_175625_s(pos);
        ServerWorld serverWorld2 = serverWorld = world instanceof WorldGenRegion ? ((WorldGenRegion)world).func_201672_e() : (ServerWorld)world;
        if (tileEntity instanceof LockableLootTileEntity) {
            ((LockableLootTileEntity)tileEntity).func_189404_a(lootLocation, random.nextLong());
        } else if (tileEntity instanceof IInventory) {
            LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootLocation);
            LootContext.Builder builder = new LootContext.Builder(serverWorld);
            lootTable.func_216118_a((IInventory)tileEntity, builder.func_216022_a(LootParameterSets.field_216260_a));
        } else if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootLocation);
                LootContext.Builder builder = new LootContext.Builder(serverWorld);
                lootTable.func_216118_a((IInventory)new ItemHandlerWrapper((IItemHandler)handler), builder.func_216022_a(LootParameterSets.field_216260_a));
            });
        }
    }
}

