/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation.processing;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.generation.processing.ProcessorTypes;

public class ForgedContainerProcessor
extends StructureProcessor {
    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, Template.BlockInfo $, Template.BlockInfo blockInfo, PlacementSettings placementSettings, @Nullable Template template) {
        if (blockInfo.field_186243_b.func_177230_c() instanceof ForgedContainerBlock) {
            Random random = (Boolean)blockInfo.field_186243_b.func_177229_b((IProperty)ForgedContainerBlock.flippedProp) != false ? placementSettings.func_189947_a(blockInfo.field_186242_a.func_177972_a(((Direction)blockInfo.field_186243_b.func_177229_b((IProperty)ForgedContainerBlock.facingProp)).func_176735_f())) : placementSettings.func_189947_a(blockInfo.field_186242_a);
            CompoundNBT newCompound = blockInfo.field_186244_c.func_74737_b();
            int[] lockIntegrity = new int[ForgedContainerTile.lockCount];
            for (int i = 0; i < lockIntegrity.length; ++i) {
                lockIntegrity[i] = 1 + random.nextInt(ForgedContainerTile.lockIntegrityMax - 1);
            }
            ForgedContainerTile.writeLockData(newCompound, lockIntegrity);
            int lidIntegrity = 1 + random.nextInt(ForgedContainerTile.lidIntegrityMax - 1);
            ForgedContainerTile.writeLidData(newCompound, lidIntegrity);
            BlockState newState = ForgedContainerTile.getUpdatedBlockState(blockInfo.field_186243_b, lockIntegrity, lidIntegrity);
            return new Template.BlockInfo(blockInfo.field_186242_a, newState, newCompound);
        }
        return blockInfo;
    }

    protected IStructureProcessorType func_215192_a() {
        return ProcessorTypes.forgedContainer;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops);
    }
}

