/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadItem;
import se.mickelus.tetra.items.modular.impl.ModularTwinHeadItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ItemToolbeltModular;

public class GuiModuleOffsets {
    static GuiModuleOffsets[] defaultMajorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(4, 0), new GuiModuleOffsets(4, 0, 4, 18), new GuiModuleOffsets(4, 0, 4, 18, -4, 0), new GuiModuleOffsets(4, 0, 4, 18, -4, 0, -4, 18)};
    static GuiModuleOffsets[] defaultMinorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(-21, 12), new GuiModuleOffsets(-18, 5, -18, 18), new GuiModuleOffsets(-12, -1, -21, 12, -12, 25)};
    static GuiModuleOffsets toolbeltMajorOffsets = new GuiModuleOffsets(-14, 18, 4, 0, 4, 18);
    static GuiModuleOffsets toolbeltMinorOffsets = new GuiModuleOffsets(-13, 0);
    static GuiModuleOffsets duplexMajorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    static GuiModuleOffsets duplexMinorOffsets = new GuiModuleOffsets(6, 1);
    static GuiModuleOffsets bowMajorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    static GuiModuleOffsets bowMinorOffsets = new GuiModuleOffsets(6, 1);
    private int[] offsetX;
    private int[] offsetY;
    private boolean[] alignment;

    public GuiModuleOffsets(int ... offsets) {
        this.offsetX = new int[offsets.length / 2];
        this.offsetY = new int[offsets.length / 2];
        this.alignment = new boolean[offsets.length / 2];
        for (int i = 0; i < offsets.length / 2; ++i) {
            this.offsetX[i] = offsets[i * 2];
            this.offsetY[i] = offsets[i * 2 + 1];
            this.alignment[i] = this.offsetX[i] > 0;
        }
    }

    public int size() {
        return this.offsetX.length;
    }

    public int getX(int index) {
        return this.offsetX[index];
    }

    public int getY(int index) {
        return this.offsetY[index];
    }

    public boolean getAlignment(int index) {
        return this.alignment[index];
    }

    public static GuiModuleOffsets getMajorOffsets(ItemModular item) {
        if (item instanceof ItemToolbeltModular) {
            return toolbeltMajorOffsets;
        }
        if (item instanceof ModularTwinHeadItem) {
            return duplexMajorOffsets;
        }
        if (item instanceof ModularBowItem) {
            return new GuiModuleOffsets(1, 21, -11, -3);
        }
        if (item instanceof ModularSingleHeadItem) {
            return new GuiModuleOffsets(1, -3, -11, 21);
        }
        return defaultMajorOffsets[item.getNumMajorModules() - 1];
    }

    public static GuiModuleOffsets getMinorOffsets(ItemModular item) {
        if (item instanceof ItemToolbeltModular) {
            return toolbeltMinorOffsets;
        }
        if (item instanceof ModularTwinHeadItem) {
            return duplexMinorOffsets;
        }
        if (item instanceof ModularBowItem) {
            return new GuiModuleOffsets(-14, 23);
        }
        if (item instanceof ModularSingleHeadItem) {
            return new GuiModuleOffsets(-14, 0);
        }
        return defaultMinorOffsets[item.getNumMinorModules() - 1];
    }
}

