/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapability;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.statbar.GuiStatBar;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.statbar.getter.StatGetterCapabilityEfficiency;
import se.mickelus.tetra.gui.statbar.getter.StatGetterCapabilityLevel;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterCapability;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBarCapability
extends GuiStatBar {
    private static final int efficiencyMax = 50;
    private GuiCapability capabilityElement;
    private IStatGetter levelGetter;
    private GuiTexture strikingIndicator;
    private IStatGetter strikingGetter;
    private GuiTexture sweepingIndicator;
    private IStatGetter sweepingGetter;

    public GuiStatBarCapability(int x, int y, int width, Capability capability) {
        super(x, y, width, "", 0.0, 50.0, false, new StatGetterCapabilityEfficiency(capability), LabelGetterBasic.decimalLabel, new TooltipGetterCapability(capability));
        this.bar.setWidth(width - 16);
        this.bar.setX(16);
        this.levelGetter = new StatGetterCapabilityLevel(capability);
        this.capabilityElement = new GuiCapability(-3, -3, capability);
        this.addChild(this.capabilityElement);
        if (capability == Capability.axe) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingAxe, 1.0);
        } else if (capability == Capability.pickaxe) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingPickaxe, 1.0);
        } else if (capability == Capability.cut) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingCut, 1.0);
        } else if (capability == Capability.shovel) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingShovel, 1.0);
        }
        this.strikingIndicator = new GuiTexture(16, -1, 7, 7, 206, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.strikingIndicator);
        this.sweepingGetter = new StatGetterEffectLevel(ItemEffect.sweepingStrike, 1.0);
        this.sweepingIndicator = new GuiTexture(16, -1, 7, 7, 213, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.sweepingIndicator);
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        super.update(player, currentStack, previewStack, slot, improvement);
        int level = (int)this.levelGetter.getValue(player, currentStack);
        int color = 0xFFFFFF;
        if (!previewStack.func_190926_b()) {
            int previewLevel = (int)this.levelGetter.getValue(player, previewStack);
            color = this.getDiffColor(level, previewLevel);
            level = previewLevel;
        } else if (slot != null) {
            int previewLevel = level - this.getSlotLevel(player, currentStack, slot, improvement);
            color = this.getDiffColor(previewLevel, level);
        }
        this.capabilityElement.update(level, color);
        this.updateIndicators(player, currentStack, previewStack, slot, improvement);
    }

    private void updateIndicators(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        int currentSweeping;
        int currentStriking;
        int previewStriking = currentStriking = this.strikingGetter != null ? (int)this.strikingGetter.getValue(player, currentStack) : 0;
        int previewSweeping = currentSweeping = (int)this.sweepingGetter.getValue(player, currentStack);
        if (!previewStack.func_190926_b()) {
            previewStriking -= this.strikingGetter != null ? (int)this.strikingGetter.getValue(player, previewStack) : 0;
            previewSweeping -= (int)this.sweepingGetter.getValue(player, previewStack);
        } else if (slot != null) {
            if (improvement != null) {
                previewStriking -= this.strikingGetter != null ? (int)this.strikingGetter.getValue(player, currentStack, slot, improvement) : 0;
                previewSweeping -= (int)this.sweepingGetter.getValue(player, currentStack, slot, improvement);
            } else {
                previewStriking -= this.strikingGetter != null ? (int)this.strikingGetter.getValue(player, currentStack, slot) : 0;
                previewSweeping -= (int)this.sweepingGetter.getValue(player, currentStack, slot);
            }
        }
        if (currentStriking > 0 || previewStriking > 0) {
            if (currentSweeping > 0 || previewSweeping > 0) {
                this.strikingIndicator.setVisible(false);
                this.sweepingIndicator.setVisible(true);
                this.sweepingIndicator.setColor(this.getDiffColor(previewSweeping, currentSweeping));
            } else {
                this.strikingIndicator.setVisible(true);
                this.sweepingIndicator.setVisible(false);
                this.strikingIndicator.setColor(this.getDiffColor(previewStriking, currentStriking));
            }
        } else {
            this.strikingIndicator.setVisible(false);
            this.sweepingIndicator.setVisible(false);
        }
    }

    @Override
    protected void realign() {
        super.realign();
        if (GuiAlignment.left.equals((Object)this.alignment)) {
            this.bar.setX(16);
            this.capabilityElement.setX(-3);
            this.strikingIndicator.setX(16);
            this.strikingIndicator.setAttachment(this.alignment.toAttachment());
            this.sweepingIndicator.setX(16);
            this.sweepingIndicator.setAttachment(this.alignment.toAttachment());
        } else {
            this.bar.setX(0);
            this.capabilityElement.setX(0);
            this.strikingIndicator.setX(-16);
            this.strikingIndicator.setAttachment(this.alignment.toAttachment());
            this.sweepingIndicator.setX(-16);
            this.sweepingIndicator.setAttachment(this.alignment.toAttachment());
        }
        this.capabilityElement.setAttachment(this.alignment.toAttachment());
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.levelGetter.getValue(player, currentStack) > 0.0 || this.levelGetter.getValue(player, previewStack) > 0.0;
    }

    protected int getDiffColor(int currentValue, int previewValue) {
        if (previewValue > currentValue) {
            return 0x55FF55;
        }
        if (previewValue < currentValue) {
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    protected int getSlotLevel(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> {
            if (improvement != null) {
                return this.levelGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.levelGetter.getValue(player, itemStack, slot);
        }).orElse(-1.0).intValue();
    }
}

