/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar.getter;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.gui.statbar.getter.StatGetterCapabilityEfficiency;
import se.mickelus.tetra.gui.statbar.getter.StatGetterCapabilityLevel;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.module.ItemEffect;

public class TooltipGetterCapability
implements ITooltipGetter {
    private final IStatGetter levelGetter;
    private final IStatGetter efficiencyGetter;
    private final String localizationKey;
    private static final String strikingKey = "stats.capability.striking";
    private IStatGetter strikingGetter;
    private static final String sweepingKey = "stats.capability.sweeping";
    private IStatGetter sweepingGetter;

    public TooltipGetterCapability(Capability capability) {
        this.localizationKey = "stats." + (Object)((Object)capability) + ".tooltip";
        this.levelGetter = new StatGetterCapabilityLevel(capability);
        this.efficiencyGetter = new StatGetterCapabilityEfficiency(capability);
        if (capability == Capability.axe) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingAxe, 1.0);
        } else if (capability == Capability.pickaxe) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingPickaxe, 1.0);
        } else if (capability == Capability.cut) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingCut, 1.0);
        } else if (capability == Capability.shovel) {
            this.strikingGetter = new StatGetterEffectLevel(ItemEffect.strikingShovel, 1.0);
        }
        this.sweepingGetter = new StatGetterEffectLevel(ItemEffect.sweepingStrike, 1.0);
    }

    @Override
    public String getTooltip(PlayerEntity player, ItemStack itemStack) {
        String modifier = "";
        if (this.strikingGetter != null && this.strikingGetter.getValue(player, itemStack) > 0.0) {
            modifier = this.sweepingGetter.getValue(player, itemStack) > 0.0 ? I18n.func_135052_a((String)sweepingKey, (Object[])new Object[0]) : I18n.func_135052_a((String)strikingKey, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)this.localizationKey, (Object[])new Object[]{modifier, (int)this.levelGetter.getValue(player, itemStack), String.format("%.2f", this.efficiencyGetter.getValue(player, itemStack))});
    }
}

