/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.items.journal.GuiJournalRootBase;
import se.mickelus.tetra.items.journal.JournalPage;
import se.mickelus.tetra.items.journal.gui.GuiJournalHeader;
import se.mickelus.tetra.items.journal.gui.blueprint.GuiJournalBlueprintRoot;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalCraftRoot;
import se.mickelus.tetra.items.journal.gui.system.GuiJournalSystemRoot;

@OnlyIn(value=Dist.CLIENT)
public class GuiJournal
extends Screen {
    private final GuiJournalHeader header;
    private final GuiJournalRootBase[] pages;
    private GuiJournalRootBase currentPage;
    private GuiElement defaultGui;
    private static GuiJournal instance;

    public GuiJournal() {
        super((ITextComponent)new StringTextComponent("tetra:holosphere"));
        this.width = 320;
        this.height = 240;
        this.defaultGui = new GuiElement(0, 0, this.width, this.height);
        this.header = new GuiJournalHeader(0, 0, this.width, this::changePage);
        this.defaultGui.addChild((GuiElement)this.header);
        this.pages = new GuiJournalRootBase[JournalPage.values().length];
        this.pages[0] = new GuiJournalCraftRoot(0, 18);
        this.defaultGui.addChild((GuiElement)this.pages[0]);
        this.pages[1] = new GuiJournalBlueprintRoot(0, 18);
        this.pages[1].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[1]);
        this.pages[2] = new GuiJournalSystemRoot(0, 18);
        this.pages[2].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[2]);
        this.currentPage = this.pages[0];
    }

    public static GuiJournal getInstance() {
        if (instance == null || ((Boolean)ConfigHandler.development.get()).booleanValue()) {
            instance = new GuiJournal();
        }
        return instance;
    }

    public void onShow() {
        this.header.onShow();
        this.currentPage.animateOpen();
    }

    private void changePage(JournalPage page) {
        this.header.changePage(page);
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setVisible(page.ordinal() == i);
        }
        this.currentPage = this.pages[page.ordinal()];
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.defaultGui.draw((this.width - this.defaultGui.getWidth()) / 2, (this.height - this.defaultGui.getHeight()) / 2, this.width, this.height, mouseX, mouseY, 1.0f);
        this.renderHoveredToolTip(mouseX, mouseY);
    }

    protected void renderHoveredToolTip(int mouseX, int mouseY) {
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            tooltipLines = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).collect(Collectors.toList());
            GuiUtils.drawHoveringText(tooltipLines, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)300, (FontRenderer)this.font);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.defaultGui.onClick((int)mouseX, (int)mouseY);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char typecChar, int keyCode) {
        this.currentPage.charTyped(typecChar);
        return false;
    }
}

