/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.journal.JournalPage;

public class GuiJournalHeader
extends GuiElement {
    private final GuiButton[] buttons;
    private final List<KeyframeAnimation> showAnimations = new ArrayList<KeyframeAnimation>();

    public GuiJournalHeader(int x, int y, int width, Consumer<JournalPage> onPageChange) {
        super(x, y, width, 12);
        int i;
        this.buttons = (GuiButton[])Arrays.stream(JournalPage.values()).map(page -> new GuiButton(0, 4, page.label, () -> onPageChange.accept((JournalPage)((Object)page)))).toArray(GuiButton[]::new);
        int spacing = width / (this.buttons.length + 1);
        for (i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setAttachmentPoint(GuiAttachment.topCenter);
            this.buttons[i].setX((i + 1) * spacing);
            this.addChild((GuiElement)this.buttons[i]);
        }
        this.changePage(JournalPage.craft);
        for (i = 0; i < this.buttons.length; ++i) {
            KeyframeAnimation animation = this.getButtonAnimation((GuiElement)this.buttons[i], i, this.buttons.length);
            this.showAnimations.add(animation);
        }
        this.setupSeparators();
    }

    private KeyframeAnimation getButtonAnimation(GuiElement button, int i, int size) {
        int delay = 1 + Math.abs(i - size / 2);
        if (i == (size + 1) / 2 - 1 && size % 2 != 0) {
            return new KeyframeAnimation(200, button).withDelay(delay * 300).applyTo(new Applier[]{new Applier.TranslateY(3.0f, 0.0f, true), new Applier.Opacity(0.0f, 0.0f, false, true)});
        }
        if (i < size / 2) {
            return new KeyframeAnimation(200, button).withDelay(delay * 300).applyTo(new Applier[]{new Applier.TranslateX(5.0f, 0.0f, true), new Applier.Opacity(0.0f, 0.0f, false, true)});
        }
        return new KeyframeAnimation(200, button).withDelay(delay * 300).applyTo(new Applier[]{new Applier.TranslateX(-5.0f, 0.0f, true), new Applier.Opacity(0.0f, 0.0f, false, true)});
    }

    private void setupSeparators() {
        GuiRect separator = new GuiRect(0, 0, this.width, 1, 0xFFFFFF);
        separator.setAttachment(GuiAttachment.topCenter);
        this.showAnimations.add(new KeyframeAnimation(800, (GuiElement)separator).applyTo(new Applier[]{new Applier.Width((float)this.width / 2.0f, (float)this.width), new Applier.Opacity(0.0f, 0.3f)}));
        this.addChild((GuiElement)separator);
        separator = new GuiRect(0, 0, this.width, 1, 0xFFFFFF);
        separator.setAttachment(GuiAttachment.topCenter);
        this.showAnimations.add(new KeyframeAnimation(200, (GuiElement)separator).applyTo(new Applier[]{new Applier.Width(0.0f, (float)this.width), new Applier.Opacity(0.0f, 0.3f)}));
        this.addChild((GuiElement)separator);
        separator = new GuiRect(0, 16, this.width, 1, 0xFFFFFF);
        separator.setAttachment(GuiAttachment.topCenter);
        this.showAnimations.add(new KeyframeAnimation(800, (GuiElement)separator).applyTo(new Applier[]{new Applier.Width((float)this.width / 1.25f, (float)this.width), new Applier.Opacity(0.0f, 0.3f)}));
        this.addChild((GuiElement)separator);
        separator = new GuiRect(0, 16, this.width, 1, 0xFFFFFF);
        separator.setAttachment(GuiAttachment.topCenter);
        this.showAnimations.add(new KeyframeAnimation(200, (GuiElement)separator).applyTo(new Applier[]{new Applier.Width((float)this.width / 2.0f, (float)this.width), new Applier.Opacity(0.0f, 0.3f)}));
        this.addChild((GuiElement)separator);
    }

    protected void onShow() {
        this.showAnimations.forEach(KeyframeAnimation::start);
    }

    public void changePage(JournalPage page) {
        for (GuiButton button : this.buttons) {
            button.setOpacity(0.5f);
        }
        this.buttons[page.ordinal()].setOpacity(1.0f);
    }
}

