/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiJournalImprovement
extends GuiElement {
    private final GuiTexture backdrop;
    private final GuiString label;
    private UpgradeSchema schema;

    public GuiJournalImprovement(int x, int y, UpgradeSchema schema) {
        super(x, y, 52, 16);
        this.schema = schema;
        this.backdrop = new GuiTexture(1, 3, 16, 9, 52, 3, GuiTextures.workbench);
        this.addChild((GuiElement)this.backdrop);
        this.addChild((GuiElement)new GuiTexture(7, 8, 7, 7, 68, 16, GuiTextures.workbench));
        this.addChild(new GuiModuleGlyph(0, 0, 16, 16, schema.getGlyph()).setShift(false));
        String schemaName = schema.getName();
        if (schemaName.length() > 4) {
            schemaName = schemaName.substring(0, 4);
        }
        this.label = new GuiString(20, 2, schemaName);
        this.addChild((GuiElement)this.label);
    }

    protected void onFocus() {
        super.onFocus();
        this.backdrop.setColor(0xFFFFCC);
        this.label.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        super.onBlur();
        this.backdrop.setColor(0xFFFFFF);
        this.label.setColor(0xFFFFFF);
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return Arrays.asList(this.schema.getName(), TextFormatting.GRAY + this.schema.getDescription(null).replace("\\n", "\n").replace("\n", "\n" + TextFormatting.GRAY));
        }
        return null;
    }
}

