/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalVariantDetail;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalVariants;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiJournalSchema
extends GuiElement {
    private GuiJournalVariants list;
    private GuiJournalVariantDetail detail;
    private OutcomePreview selectedVariant;
    private OutcomePreview hoveredVariant;
    String slot;

    public GuiJournalSchema(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.list = new GuiJournalVariants(0, 0, width, this::onVariantHover, this::onVariantBlur, this::onVariantSelect);
        this.addChild(this.list);
        this.detail = new GuiJournalVariantDetail(0, 50, width);
        this.addChild(this.detail);
    }

    public void update(ItemModular item, String slot, UpgradeSchema schema) {
        this.list.update(item, slot, schema);
        this.slot = slot;
        this.selectedVariant = null;
        this.hoveredVariant = null;
        this.detail.updateVariant(null, null, slot);
    }

    private void onVariantHover(OutcomePreview outcome) {
        this.hoveredVariant = outcome;
        this.detail.updateVariant(this.selectedVariant, this.hoveredVariant, this.slot);
    }

    private void onVariantBlur(OutcomePreview outcome) {
        if (outcome.equals(this.hoveredVariant)) {
            this.detail.updateVariant(this.selectedVariant, null, this.slot);
        }
    }

    private void onVariantSelect(OutcomePreview outcome) {
        this.selectedVariant = outcome;
        this.list.updateSelection(outcome);
        this.detail.updateVariant(this.selectedVariant, this.hoveredVariant, this.slot);
    }

    public void animateOpen() {
        this.list.onShow();
        if (this.selectedVariant != null) {
            this.detail.animateOpen();
        }
    }

    protected void onShow() {
        this.list.setVisible(true);
    }

    protected boolean onHide() {
        this.list.setVisible(false);
        this.detail.hide();
        return true;
    }
}

