/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.statbar.GuiStatBarCapability;
import se.mickelus.tetra.gui.statbar.GuiStatBase;
import se.mickelus.tetra.gui.statbar.GuiStats;
import se.mickelus.tetra.items.modular.ItemModular;

public class GuiJournalStats
extends GuiElement {
    private List<GuiStatBase> bars = new LinkedList<GuiStatBase>();
    private GuiElement barGroup = new GuiElement(0, 0, this.width, this.height);

    public GuiJournalStats(int x, int y) {
        super(x, y, 200, 52);
        this.addChild(this.barGroup);
        this.bars.add(GuiStats.integrity);
        this.bars.add(GuiStats.damage);
        this.bars.add(GuiStats.speedNormalized);
        this.bars.add(GuiStats.rangedSpeedNormalized);
        this.bars.add(GuiStats.reach);
        this.bars.add(GuiStats.durability);
        this.bars.add(GuiStats.armor);
        this.bars.add(GuiStats.quickslot);
        this.bars.add(GuiStats.potion_storage);
        this.bars.add(GuiStats.storage);
        this.bars.add(GuiStats.quiver);
        this.bars.add(GuiStats.booster);
        this.bars.add(GuiStats.sweeping);
        this.bars.add(GuiStats.bleeding);
        this.bars.add(GuiStats.backstab);
        this.bars.add(GuiStats.armorPenetration);
        this.bars.add(GuiStats.unarmoredDamage);
        this.bars.add(GuiStats.knockback);
        this.bars.add(GuiStats.looting);
        this.bars.add(GuiStats.fiery);
        this.bars.add(GuiStats.smite);
        this.bars.add(GuiStats.arthropod);
        this.bars.add(GuiStats.unbreaking);
        this.bars.add(GuiStats.mending);
        this.bars.add(GuiStats.silkTouch);
        this.bars.add(GuiStats.fortune);
        this.bars.add(GuiStats.infinity);
        this.bars.add(GuiStats.flame);
        this.bars.add(GuiStats.punch);
        this.bars.add(GuiStats.quickStrike);
        this.bars.add(GuiStats.softStrike);
        this.bars.add(GuiStats.fierySelf);
        this.bars.add(GuiStats.enderReverb);
        this.bars.add(GuiStats.criticalStrike);
        this.bars.add(GuiStats.earthbind);
        this.bars.add(GuiStats.releaseLatch);
        this.bars.add(GuiStats.overbowed);
        this.bars.add(GuiStats.intuit);
        this.bars.add(GuiStats.magicCapacity);
        Arrays.stream(Capability.values()).map(capability -> new GuiStatBarCapability(0, 0, 59, (Capability)((Object)capability))).forEach(this.bars::add);
        this.bars.forEach(bar -> bar.setAttachmentAnchor(GuiAttachment.bottomCenter));
    }

    public void update(ItemStack itemStack, ItemStack previewStack, String slot, String improvement, PlayerEntity player) {
        boolean shouldShow = !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemModular;
        this.setVisible(shouldShow);
        if (shouldShow) {
            this.barGroup.clearChildren();
            this.bars.stream().filter(bar -> bar.shouldShow(player, itemStack, previewStack, slot, improvement)).forEach(bar -> {
                bar.update(player, itemStack, previewStack, slot, improvement);
                this.realignBar((GuiStatBase)((Object)bar), this.barGroup.getNumChildren());
                this.barGroup.addChild((GuiElement)bar);
            });
        }
    }

    private void realignBar(GuiStatBase bar, int index) {
        bar.setAttachment(GuiAttachment.topLeft);
        bar.setAlignment(GuiAlignment.left);
        bar.setX(index % 3 * 69);
        bar.setY(17 * (index / 3));
    }

    public void realignBars() {
        for (int i = 0; i < this.barGroup.getNumChildren(); ++i) {
            this.realignBar((GuiStatBase)this.barGroup.getChild(i), i);
        }
    }
}

