/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.forgespi.Environment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.text.WordUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.client.model.ModularModelLoader;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.modular.IItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ModuleVariantData;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.schema.RepairDefinition;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.util.CastOptional;

public abstract class ItemModular
extends TetraItem
implements IItemModular,
ICapabilityProvider {
    protected static final String identifierKey = "id";
    protected static final String repairCountKey = "repairCount";
    protected static final String cooledStrengthKey = "cooledStrength";
    private static final String honeProgressKey = "honing_progress";
    private static final String honeAvailableKey = "honing_available";
    private static final String honeCountKey = "honing_count";
    protected int honeBase = 450;
    protected int honeIntegrityMultiplier = 200;
    protected String[] majorModuleKeys;
    protected String[] minorModuleKeys;
    protected String[] requiredModules = new String[0];
    protected int baseDurability = 0;
    protected int baseIntegrity = 0;
    protected SynergyData[] synergies = new SynergyData[0];

    public ItemModular(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void clientInit() {
        ModularModelLoader.registerItem(this);
    }

    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return Optional.of(this.getIdentifier(itemStack)).filter(id -> !id.isEmpty()).orElseGet(() -> NBTHelper.getTag(itemStack).toString());
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)(this.getAllModules(stack).stream().map(itemModule -> itemModule.getDurability(stack)).reduce(0, Integer::sum) + this.baseDurability) * this.getDurabilityMultiplier(stack));
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().map(itemModule -> Float.valueOf(itemModule.getDurabilityMultiplier(itemStack))).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public static int getIntegrityGain(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            return ((ItemModular)itemStack.func_77973_b()).getAllModules(itemStack).stream().map(module -> module.getIntegrityGain(itemStack)).reduce(0, Integer::sum);
        }
        return 0;
    }

    public static int getIntegrityCost(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            return ((ItemModular)itemStack.func_77973_b()).getAllModules(itemStack).stream().map(module -> module.getIntegrityCost(itemStack)).reduce(0, Integer::sum);
        }
        return 0;
    }

    protected Collection<ItemModule> getAllModules(ItemStack stack) {
        CompoundNBT stackTag = NBTHelper.getTag(stack);
        if (stackTag != null) {
            return Stream.concat(Arrays.stream(this.majorModuleKeys), Arrays.stream(this.minorModuleKeys)).map(arg_0 -> ((CompoundNBT)stackTag).func_74779_i(arg_0)).map(ItemUpgradeRegistry.instance::getModule).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public ItemModuleMajor[] getMajorModules(ItemStack itemStack) {
        ItemModuleMajor[] modules = new ItemModuleMajor[this.majorModuleKeys.length];
        CompoundNBT stackTag = NBTHelper.getTag(itemStack);
        for (int i = 0; i < this.majorModuleKeys.length; ++i) {
            String moduleName = stackTag.func_74779_i(this.majorModuleKeys[i]);
            ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleName);
            if (!(module instanceof ItemModuleMajor)) continue;
            modules[i] = (ItemModuleMajor)module;
        }
        return modules;
    }

    @Override
    public ItemModule[] getMinorModules(ItemStack itemStack) {
        ItemModule[] modules = new ItemModule[this.minorModuleKeys.length];
        CompoundNBT stackTag = NBTHelper.getTag(itemStack);
        for (int i = 0; i < this.minorModuleKeys.length; ++i) {
            ItemModule module;
            String moduleName = stackTag.func_74779_i(this.minorModuleKeys[i]);
            modules[i] = module = ItemUpgradeRegistry.instance.getModule(moduleName);
        }
        return modules;
    }

    @Override
    public boolean isModuleRequired(String moduleSlot) {
        return ArrayUtils.contains((Object[])this.requiredModules, (Object)moduleSlot);
    }

    @Override
    public int getNumMajorModules() {
        return this.majorModuleKeys.length;
    }

    @Override
    public String[] getMajorModuleKeys() {
        return this.majorModuleKeys;
    }

    @Override
    public String[] getMajorModuleNames() {
        return (String[])Arrays.stream(this.majorModuleKeys).map(key -> I18n.func_135052_a((String)key, (Object[])new Object[0])).toArray(String[]::new);
    }

    @Override
    public int getNumMinorModules() {
        return this.minorModuleKeys.length;
    }

    @Override
    public String[] getMinorModuleKeys() {
        return this.minorModuleKeys;
    }

    @Override
    public String[] getMinorModuleNames() {
        return (String[])Arrays.stream(this.minorModuleKeys).map(key -> I18n.func_135052_a((String)key, (Object[])new Object[0])).toArray(String[]::new);
    }

    @Override
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        return this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public boolean hasModule(ItemStack itemStack, ItemModule module) {
        return this.getAllModules(itemStack).stream().anyMatch(module::equals);
    }

    public static void putModuleInSlot(ItemStack itemStack, String slot, String module, String moduleVariantKey, String moduleVariant) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        tag.func_74778_a(slot, module);
        tag.func_74778_a(moduleVariantKey, moduleVariant);
    }

    public ItemModule getModuleFromSlot(ItemStack itemStack, String slot) {
        return ItemUpgradeRegistry.instance.getModule(NBTHelper.getTag(itemStack).func_74779_i(slot));
    }

    public void tickProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue()) {
            return;
        }
        this.tickHoningProgression(entity, itemStack, multiplier);
        for (ItemModuleMajor module : this.getMajorModules(itemStack)) {
            module.tickProgression(entity, itemStack, multiplier);
        }
    }

    public void tickHoningProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue()) {
            return;
        }
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        if (!ItemModular.isHoneable(itemStack)) {
            int honingProgress = tag.func_74764_b(honeProgressKey) ? tag.func_74762_e(honeProgressKey) : this.getHoningBase(itemStack);
            tag.func_74768_a(honeProgressKey, honingProgress -= multiplier);
            if (honingProgress <= 0 && !ItemModular.isHoneable(itemStack)) {
                tag.func_74757_a(honeAvailableKey, true);
                if (entity instanceof ServerPlayerEntity) {
                    PacketHandler.sendTo(new HonePacket(itemStack), (ServerPlayerEntity)entity);
                }
            }
        }
    }

    public int getHoningProgress(ItemStack itemStack) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        if (tag.func_74764_b(honeProgressKey)) {
            return tag.func_74762_e(honeProgressKey);
        }
        return this.getHoningBase(itemStack);
    }

    public void setHoningProgress(ItemStack itemStack, int progress) {
        NBTHelper.getTag(itemStack).func_74768_a(honeProgressKey, progress);
    }

    public int getHoningBase(ItemStack itemStack) {
        return Math.max(this.honeBase + this.honeIntegrityMultiplier * -ItemModular.getIntegrityCost(itemStack), 1);
    }

    public int getHonedCount(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(honeCountKey);
    }

    public static boolean isHoneable(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74764_b(honeAvailableKey);
    }

    public static int getHoningSeed(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(honeCountKey) + 1;
    }

    public static void removeHoneable(ItemStack itemStack) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        tag.func_82580_o(honeAvailableKey);
        tag.func_82580_o(honeProgressKey);
        tag.func_74768_a(honeCountKey, tag.func_74762_e(honeCountKey) + 1);
    }

    protected void causeFierySelfEffect(LivingEntity entity, ItemStack itemStack, double multiplier) {
        double fierySelfEfficiency;
        if (!entity.field_70170_p.field_72995_K && (fierySelfEfficiency = this.getEffectEfficiency(itemStack, ItemEffect.fierySelf)) > 0.0) {
            BlockPos pos = entity.func_180425_c();
            float temperature = entity.field_70170_p.func_180494_b(pos).func_180626_a(pos);
            if (entity.func_70681_au().nextDouble() < fierySelfEfficiency * (double)temperature * multiplier) {
                entity.func_70015_d(this.getEffectLevel(itemStack, ItemEffect.fierySelf));
            }
        }
    }

    protected void causeEnderReverbEffect(LivingEntity entity, ItemStack itemStack, double multiplier) {
        AxisAlignedBB aabb;
        List nearbyTargets;
        double effectProbability;
        if (!entity.field_70170_p.field_72995_K && (effectProbability = this.getEffectEfficiency(itemStack, ItemEffect.enderReverb)) > 0.0 && entity.func_70681_au().nextDouble() < effectProbability * multiplier && (nearbyTargets = entity.field_70170_p.func_175647_a(LivingEntity.class, aabb = new AxisAlignedBB(entity.func_180425_c()).func_186662_g(24.0), target -> target instanceof EndermanEntity || target instanceof EndermiteEntity || target instanceof ShulkerEntity || target instanceof EnderDragonEntity)).size() > 0) {
            ((LivingEntity)nearbyTargets.get(entity.func_70681_au().nextInt(nearbyTargets.size()))).func_70604_c(entity);
        }
    }

    protected void causeHauntEffect(LivingEntity entity, ItemStack itemStack, double multiplier) {
        double effectProbability;
        if (!entity.field_70170_p.field_72995_K && (effectProbability = this.getEffectEfficiency(itemStack, ItemEffect.haunted)) > 0.0 && entity.func_70681_au().nextDouble() < effectProbability * multiplier) {
            int effectLevel = this.getEffectLevel(itemStack, ItemEffect.haunted);
            VexEntity vex = (VexEntity)EntityType.field_200755_au.func_200721_a(entity.field_70170_p);
            vex.func_190653_a(effectLevel * 20);
            vex.func_70012_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, entity.field_70177_z, 0.0f);
            vex.func_184611_a(Hand.MAIN_HAND, itemStack.func_77946_l());
            vex.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
            vex.func_195064_c(new EffectInstance(Effects.field_76441_p, 2000 + effectLevel * 20));
            entity.field_70170_p.func_217376_c((Entity)vex);
            CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> Arrays.stream(item.getMajorModules(itemStack))).orElse(Stream.empty()).filter(Objects::nonNull).filter(module -> module.getImprovement(itemStack, "destabilized/haunted") != null).findAny().ifPresent(module -> {
                int level = module.getImprovementLevel(itemStack, "destabilized/haunted");
                if (level > 0) {
                    module.addImprovement(itemStack, "destabilized/haunted", level - 1);
                } else {
                    module.removeImprovement(itemStack, "destabilized/haunted");
                }
            });
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187920_gt, SoundCategory.PLAYERS, 2.0f, 2.0f);
        }
    }

    public void applyUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        this.tickProgression(entity, itemStack, (int)multiplier);
        this.causeHauntEffect(entity, itemStack, multiplier);
        this.causeFierySelfEffect(entity, itemStack, multiplier);
        this.causeEnderReverbEffect(entity, itemStack, multiplier);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        super.setDamage(itemStack, Math.min(itemStack.func_77958_k() - 1, damage));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return Math.min(stack.func_77958_k() - stack.func_77952_i() - 1, amount);
    }

    public void applyDamage(int amount, ItemStack itemStack, LivingEntity responsibleEntity) {
        int maxDamage;
        int damage = itemStack.func_77952_i();
        if (!this.isBroken(damage, maxDamage = itemStack.func_77958_k())) {
            int reducedAmount = this.getReducedDamage(amount, itemStack, responsibleEntity);
            itemStack.func_222118_a(reducedAmount, responsibleEntity, breaker -> breaker.func_213334_d(breaker.func_184600_cs()));
            if (this.isBroken(damage + reducedAmount, maxDamage) && !responsibleEntity.field_70170_p.field_72995_K) {
                responsibleEntity.func_213334_d(responsibleEntity.func_184600_cs());
                responsibleEntity.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 1.0f);
            }
        }
    }

    private int getReducedDamage(int amount, ItemStack itemStack, LivingEntity responsibleEntity) {
        if (amount > 0) {
            int level = this.getEffectLevel(itemStack, ItemEffect.unbreaking);
            int reduction = 0;
            if (level > 0) {
                for (int i = 0; i < amount; ++i) {
                    if (!UnbreakingEnchantment.func_92097_a((ItemStack)itemStack, (int)level, (Random)responsibleEntity.field_70170_p.field_73012_v)) continue;
                    ++reduction;
                }
            }
            return amount - reduction;
        }
        return amount;
    }

    public boolean isBroken(ItemStack itemStack) {
        return this.isBroken(itemStack.func_77952_i(), itemStack.func_77958_k());
    }

    private boolean isBroken(int damage, int maxDamage) {
        return maxDamage != 0 && damage >= maxDamage - 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        Style basicStyle = new Style().func_150238_a(TextFormatting.GRAY);
        if (this.isBroken(itemStack)) {
            tooltip.add(new TranslationTextComponent("item.tetra.modular.broken", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED).func_150217_b(Boolean.valueOf(true))));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add(Tooltips.expanded);
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                tooltip.add(new StringTextComponent("\u00bb " + module.getName(itemStack)).func_150255_a(basicStyle));
                Arrays.stream(module.getImprovements(itemStack)).map(improvement -> String.format(" - %s", this.getImprovementTooltip(improvement.key, improvement.level, true))).map(StringTextComponent::new).map(textComponent -> textComponent.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY))).forEach(tooltip::add);
            });
            Arrays.stream(this.getMinorModules(itemStack)).filter(Objects::nonNull).map(module -> "* " + module.getName(itemStack)).map(StringTextComponent::new).map(textComponent -> textComponent.func_150255_a(basicStyle)).forEach(tooltip::add);
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue()) {
                if (ItemModular.isHoneable(itemStack)) {
                    tooltip.add(new StringTextComponent(" > ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150257_a(new TranslationTextComponent("hone.available", new Object[0]).func_150255_a(basicStyle)));
                } else {
                    int progress = this.getHoningProgress(itemStack);
                    int base = this.getHoningBase(itemStack);
                    String result = String.format("%.1f", Float.valueOf(100.0f * (float)(base - progress) / (float)base));
                    tooltip.add(new StringTextComponent(" > ").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_AQUA)).func_150257_a(new TranslationTextComponent("hone.progress", new Object[]{result}).func_150255_a(basicStyle)));
                }
            }
        } else {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).filter(improvement -> improvement.enchantment).collect(Collectors.groupingBy(ModuleVariantData::getKey, Collectors.summingInt(ImprovementData::getLevel))).entrySet().stream().map(entry -> this.getImprovementTooltip((String)entry.getKey(), (Integer)entry.getValue(), false)).map(StringTextComponent::new).map(text -> text.func_150255_a(basicStyle)).forEach(tooltip::add);
            tooltip.add(Tooltips.expand);
        }
    }

    private String getImprovementTooltip(String key, int level, boolean clearFormatting) {
        String tooltip = I18n.func_135052_a((String)(key + ".name"), (Object[])new Object[0]);
        if (level > 0) {
            tooltip = tooltip + " " + I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]);
        }
        if (clearFormatting) {
            return TextFormatting.func_110646_a((String)tooltip);
        }
        return tooltip;
    }

    private Optional<ItemModule> getRepairModule(ItemStack itemStack) {
        List modules = this.getAllModules(itemStack).stream().filter(itemModule -> !itemModule.getRepairDefinitions(itemStack).isEmpty()).collect(Collectors.toList());
        if (modules.size() > 0) {
            int repairCount = this.getRepairCount(itemStack);
            return Optional.of(modules.get(repairCount % modules.size()));
        }
        return Optional.empty();
    }

    public String getRepairModuleName(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getName(itemStack)).orElse(null);
    }

    public String getRepairSlot(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(ItemModule::getSlot).orElse(null);
    }

    public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinitions(itemStack)).orElse(null);
    }

    public int getRepairMaterialCount(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.material.count).orElse(0);
    }

    public int getRepairAmount(ItemStack itemStack) {
        return this.getMaxDamage(itemStack);
    }

    public Collection<Capability> getRepairRequiredCapabilities(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredCapabilities(itemStack, materialStack)).orElse(Collections.emptyList());
    }

    public int getRepairRequiredCapabilityLevel(ItemStack itemStack, ItemStack materialStack, Capability capability) {
        return this.getRepairModule(itemStack).filter(module -> module.getRepairRequiredCapabilities(itemStack, materialStack).contains((Object)capability)).map(module -> module.getRepairRequiredCapabilityLevel(itemStack, materialStack, capability)).map(level -> Math.max(1, level)).orElse(0);
    }

    public int getRepairRequiredExperience(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getMagicCapacity(itemStack)).map(capacity -> Math.max(0, -capacity.intValue())).orElse(0);
    }

    private int getRepairCount(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74762_e(repairCountKey);
    }

    private void incrementRepairCount(ItemStack itemStack) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        tag.func_74768_a(repairCountKey, tag.func_74762_e(repairCountKey) + 1);
    }

    public void repair(ItemStack itemStack) {
        this.setDamage(itemStack, this.getDamage(itemStack) - this.getRepairAmount(itemStack));
        this.incrementRepairCount(itemStack);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack((IItemProvider)this);
    }

    public static void updateIdentifier(ItemStack itemStack) {
        NBTHelper.getTag(itemStack).func_74778_a(identifierKey, UUID.randomUUID().toString());
    }

    public String getIdentifier(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74779_i(identifierKey);
    }

    @Override
    public void assemble(ItemStack itemStack, World world, float severity) {
        if (itemStack.func_77952_i() > itemStack.func_77958_k()) {
            itemStack.func_196085_b(itemStack.func_77958_k());
        }
        this.applyDestabilizationEffects(itemStack, world, severity);
        CompoundNBT nbt = NBTHelper.getTag(itemStack);
        nbt.func_74768_a("HideFlags", 1);
        EnchantmentHelper.func_82782_a(this.getEnchantmentsFromImprovements(itemStack), (ItemStack)itemStack);
        ItemModular.updateIdentifier(itemStack);
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        ItemModular.updateIdentifier(itemStack);
    }

    public Map<Enchantment, Integer> getEnchantmentsFromImprovements(ItemStack itemStack) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> Arrays.stream(item.getMajorModules(itemStack))).orElseGet(Stream::empty).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).forEach(improvement -> {
            for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)) {
                enchantments.merge(mapping.enchantment, (int)((float)improvement.level * mapping.multiplier), Integer::sum);
            }
        });
        return enchantments;
    }

    public int getEnchantmentLevelFromImprovements(ItemStack itemStack, Enchantment enchantment) {
        return Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    public int getEnchantmentLevelFromImprovements(ItemStack itemStack, String slot, Enchantment enchantment) {
        return CastOptional.cast(this.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).map(module -> Arrays.stream(module.getImprovements(itemStack))).orElseGet(Stream::empty).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    public int getEnchantmentLevelFromImprovements(ItemStack itemStack, String slot, String improvementKey, Enchantment enchantment) {
        return CastOptional.cast(this.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).map(module -> Arrays.stream(module.getImprovements(itemStack))).orElseGet(Stream::empty).filter(improvement -> improvementKey.equals(improvement.key)).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    private void applyDestabilizationEffects(ItemStack itemStack, World world, float probabilityMultiplier) {
        if (!world.field_72995_K) {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                int instability = -module.getMagicCapacity(itemStack);
                for (DestabilizationEffect effect : DestabilizationEffect.getEffectsForImprovement(instability, module.getImprovements(itemStack))) {
                    int currentEffectLevel = module.getImprovementLevel(itemStack, effect.destabilizationKey);
                    int newLevel = currentEffectLevel >= 0 ? currentEffectLevel + 1 : (effect.minLevel == effect.maxLevel ? effect.minLevel : effect.minLevel + world.field_73012_v.nextInt(effect.maxLevel - effect.minLevel));
                    if (!module.acceptsImprovementLevel(effect.destabilizationKey, newLevel) || !(effect.probability * (float)instability * probabilityMultiplier > world.field_73012_v.nextFloat())) continue;
                    module.addImprovement(itemStack, effect.destabilizationKey, newLevel);
                }
            });
        }
    }

    public void tweak(ItemStack itemStack, String slot, Map<String, Integer> tweaks) {
        ItemModule module = this.getModuleFromSlot(itemStack, slot);
        float durabilityFactor = 0.0f;
        if (module == null || !module.isTweakable(itemStack)) {
            return;
        }
        if (itemStack.func_77984_f()) {
            durabilityFactor = (float)itemStack.func_77952_i() * 1.0f / (float)itemStack.func_77958_k();
        }
        tweaks.forEach((tweakKey, step) -> {
            if (module.hasTweak(itemStack, (String)tweakKey)) {
                module.setTweakStep(itemStack, (String)tweakKey, (int)step);
            }
        });
        if (itemStack.func_77984_f()) {
            itemStack.func_196085_b((int)(durabilityFactor * (float)itemStack.func_77958_k() - durabilityFactor * durabilityFactor * (float)module.getDurability(itemStack)));
        }
    }

    public int getCapabilityLevel(ItemStack itemStack, ToolType toolType) {
        if (toolType != null) {
            return this.getCapabilityLevel(itemStack, toolType.getName());
        }
        return -1;
    }

    public int getCapabilityLevel(ItemStack itemStack, String capability) {
        if (EnumUtils.isValidEnum(Capability.class, (String)capability)) {
            return this.getCapabilityLevel(itemStack, Capability.valueOf(capability));
        }
        return -1;
    }

    @Override
    public int getCapabilityLevel(ItemStack itemStack, Capability capability) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        int base = this.getAllModules(itemStack).stream().map(module -> module.getCapabilityLevel(itemStack, capability)).max(Integer::compare).orElse(-1);
        int synergyBonus = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.capabilities).mapToInt(capabilityData -> capabilityData.getLevel(capability)).sum();
        return base + synergyBonus;
    }

    public float getCapabilityEfficiency(ItemStack itemStack, ToolType toolType) {
        if (toolType != null) {
            return this.getCapabilityEfficiency(itemStack, toolType.getName());
        }
        return -1.0f;
    }

    public float getCapabilityEfficiency(ItemStack itemStack, String capability) {
        if (EnumUtils.isValidEnum(Capability.class, (String)capability)) {
            return this.getCapabilityEfficiency(itemStack, Capability.valueOf(capability));
        }
        return -1.0f;
    }

    @Override
    public float getCapabilityEfficiency(ItemStack itemStack, Capability capability) {
        if (this.isBroken(itemStack)) {
            return 0.0f;
        }
        if (this.getCapabilityLevel(itemStack, capability) <= 0) {
            return 0.0f;
        }
        int highestLevel = this.getAllModules(itemStack).stream().map(module -> module.getCapabilityLevel(itemStack, capability)).max(Integer::compare).orElse(-1);
        float efficiency = this.getAllModules(itemStack).stream().filter(module -> module.getCapabilityLevel(itemStack, capability) >= highestLevel).map(module -> Float.valueOf(module.getCapabilityEfficiency(itemStack, capability))).max(Float::compare).orElse(Float.valueOf(1.0f)).floatValue() + (float)this.getAllModules(itemStack).stream().filter(module -> module.getCapabilityLevel(itemStack, capability) == 0).mapToDouble(module -> module.getCapabilityEfficiency(itemStack, capability)).sum();
        return Math.max(0.0f, efficiency + (float)Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.capabilities).mapToDouble(capabilityData -> capabilityData.getEfficiency(capability)).sum());
    }

    @Override
    public Collection<Capability> getCapabilities(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getAllModules(itemStack).stream().flatMap(module -> module.getCapabilities(itemStack).stream()).collect(Collectors.toSet());
    }

    public ItemStack onCraftConsumeCapability(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, Capability capability, int capabilityLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }

    public ItemStack onActionConsumeCapability(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, Capability capability, int capabilityLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        return this.getAllModules(itemStack).stream().mapToInt(module -> module.getEffectLevel(itemStack, effect)).sum();
    }

    public double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return this.getAllModules(itemStack).stream().mapToDouble(module -> module.getEffectEfficiency(itemStack, effect)).sum();
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getAllModules(itemStack).stream().flatMap(module -> module.getEffects(itemStack).stream()).distinct().collect(Collectors.toSet());
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).anyMatch(improvement -> improvement.enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public ImprovementData[] getImprovements(ItemStack itemStack) {
        return (ImprovementData[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).toArray(ImprovementData[]::new);
    }

    protected String getDisplayNamePrefixes(ItemStack itemStack) {
        return Stream.concat(Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])), this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemPrefixPriority(itemStack))).map(module -> module.getItemPrefix(itemStack)).filter(Objects::nonNull)).limit(2L).reduce("", (result, prefix) -> result + prefix + " ");
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        if (Environment.get().getDist().isDedicatedServer()) {
            return new StringTextComponent("");
        }
        String name = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.name).filter(Objects::nonNull).filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().orElse(null);
        if (name == null) {
            name = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemNamePriority(itemStack))).map(module -> module.getItemName(itemStack)).filter(Objects::nonNull).findFirst().orElse("");
        }
        String prefixes = this.getDisplayNamePrefixes(itemStack);
        return new StringTextComponent(WordUtils.capitalize((String)(prefixes + name)));
    }

    public SynergyData[] getAllSynergyData(ItemStack itemStack) {
        return this.synergies;
    }

    public SynergyData[] getSynergyData(ItemStack itemStack) {
        if (this.synergies.length > 0) {
            ArrayList<SynergyData> result = new ArrayList<SynergyData>();
            String[] moduleKeys = (String[])this.getAllModules(itemStack).stream().map(ItemModule::getUnlocalizedName).sorted().toArray(String[]::new);
            String[] variantKeys = (String[])this.getAllModules(itemStack).stream().map(module -> module.getVariantData(itemStack)).map(data -> data.key).sorted().toArray(String[]::new);
            for (SynergyData synergy : this.synergies) {
                int variantMatches = 0;
                int moduleMatches = 0;
                for (String variantKey : variantKeys) {
                    if (variantMatches == synergy.moduleVariants.length) break;
                    if (!variantKey.equals(synergy.moduleVariants[variantMatches])) continue;
                    ++variantMatches;
                }
                for (String moduleKey : moduleKeys) {
                    if (moduleMatches == synergy.modules.length) break;
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    ++moduleMatches;
                }
                if ((synergy.moduleVariants.length <= 0 || variantMatches != synergy.moduleVariants.length) && (synergy.modules.length <= 0 || moduleMatches != synergy.modules.length)) continue;
                result.add(synergy);
            }
            return result.toArray(new SynergyData[result.size()]);
        }
        return new SynergyData[0];
    }
}

