/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.effects.BleedingEffect;
import se.mickelus.tetra.effects.EarthboundEffect;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class ItemModularHandheld
extends ItemModular {
    private static final Set<Block> axeDestroyBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196666_p, Blocks.field_196668_q, Blocks.field_196670_r, Blocks.field_196672_s, Blocks.field_150342_X, Blocks.field_196626_Q, Blocks.field_196629_R, Blocks.field_196631_S, Blocks.field_196634_T, Blocks.field_196637_U, Blocks.field_196639_V, Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_196628_cT, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_196663_cq, Blocks.field_196665_cr, Blocks.field_196667_cs, Blocks.field_196669_ct, Blocks.field_196673_cv, Blocks.field_196671_cu});
    private static final Set<Material> axeHarvestMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z});
    private static final Set<Block> pickaxeDestroyBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp});
    private static final Set<Material> pickaxeHarvestMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e});
    private static final Set<Block> shovelDestroyBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh});
    private static final Set<Block> shovelHarvestBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150433_aE, Blocks.field_196604_cC});
    private static final Set<Material> cuttingDestroyMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151572_C, Material.field_151569_G});
    private static final Set<Tag<Block>> cuttingDestroyTags = Sets.newHashSet((Object[])new Tag[]{BlockTags.field_206952_E});
    private static final Set<Block> cuttingHarvestBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_196553_aF});
    private static final ResourceLocation nailedTag = new ResourceLocation("tetra:nailed");
    protected static final Map<Block, BlockState> tillLookup = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    protected static final Map<Block, BlockState> flattenLookup = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));
    protected static final Map<Block, Block> stripLookup = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).build();
    protected static final UUID REACH_MODIFIER = UUID.fromString("A7A35FFA-0B44-4AA5-9880-4BD28425E275");
    protected static final UUID ARMOR_MODIFIER = UUID.fromString("D96050BE-6A94-4A27-AA0B-2AF705327BA4");
    protected int blockDestroyDamage = 1;
    protected int entityHitDamage = 1;

    public ItemModularHandheld(Item.Properties properties) {
        super(properties);
    }

    public int getBlockDestroyDamage() {
        return this.blockDestroyDamage;
    }

    public int getEntityHitDamage() {
        return this.entityHitDamage;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.func_185887_b((IBlockReader)world, pos) > 0.0f) {
            this.applyDamage(this.blockDestroyDamage, itemStack, entity);
            if (!this.isBroken(itemStack)) {
                this.applyUsageEffects(entity, itemStack, 1.0);
            }
        }
        this.applyBreakEffects(itemStack, world, state, pos, entity);
        return true;
    }

    public void applyBreakEffects(ItemStack itemStack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        int xp;
        int intuitLevel;
        if (!world.field_72995_K && (intuitLevel = this.getEffectLevel(itemStack, ItemEffect.intuit)) > 0 && (xp = state.getExpDrop((IWorldReader)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack))) > 0) {
            this.tickHoningProgression(entity, itemStack, xp);
        }
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.applyDamage(this.entityHitDamage, itemStack, attacker);
        if (!this.isBroken(itemStack)) {
            this.applyHitEffects(itemStack, target, attacker);
            this.applyUsageEffects(attacker, itemStack, 1.0);
        }
        return true;
    }

    public void applyHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int earthbindLevel;
        int bleedingLevel;
        this.getAllModules(itemStack).forEach(module -> module.hitEntity(itemStack, target, attacker));
        int sweepingLevel = this.getEffectLevel(itemStack, ItemEffect.sweeping);
        if (sweepingLevel > 0) {
            this.sweepAttack(itemStack, target, attacker, sweepingLevel);
        }
        if ((bleedingLevel = this.getEffectLevel(itemStack, ItemEffect.bleeding)) > 0 && !CreatureAttribute.field_223223_b_.equals(target.func_70668_bt()) && attacker.func_70681_au().nextFloat() < 0.3f) {
            target.func_195064_c(new EffectInstance((Effect)BleedingEffect.instance, 40, bleedingLevel));
        }
        if ((earthbindLevel = this.getEffectLevel(itemStack, ItemEffect.earthbind)) > 0 && (double)attacker.func_70681_au().nextFloat() < Math.max(0.1, 0.5 * (1.0 - target.field_70163_u / 128.0))) {
            target.func_195064_c(new EffectInstance((Effect)EarthboundEffect.instance, 80, 0, false, true));
            if (target.field_70170_p instanceof ServerWorld) {
                BlockState blockState = target.field_70170_p.func_180495_p(new BlockPos(target.field_70165_t, target.field_70163_u - 1.0, target.field_70161_v));
                ((ServerWorld)target.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), target.field_70165_t, target.field_70163_u + 0.1, target.field_70161_v, 16, 0.0, target.field_70170_p.field_73012_v.nextGaussian() * 0.2, 0.0, 0.1);
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        int denailingLevel;
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack itemStack = player.func_184586_b(hand);
        ActionResultType result = super.func_195939_a(context);
        if (this.getEffectLevel(itemStack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)itemStack) > 0) {
            return result;
        }
        int flatteningLevel = this.getEffectLevel(itemStack, ItemEffect.flattening);
        int strippingLevel = this.getEffectLevel(itemStack, ItemEffect.stripping);
        if (flatteningLevel > 0 && (strippingLevel > 0 && player.func_70093_af() || strippingLevel == 0)) {
            result = this.flattenPath(player, world, pos, hand, facing);
        } else if (strippingLevel > 0) {
            result = this.stripBlock(context);
        }
        int tillingLevel = this.getEffectLevel(itemStack, ItemEffect.tilling);
        if (tillingLevel > 0) {
            result = this.tillBlock(context);
        }
        if ((denailingLevel = this.getEffectLevel(itemStack, ItemEffect.denailing)) > 0 && (double)player.func_184825_o(0.0f) > 0.9 && (result = this.denailBlock(player, world, pos, hand, facing)).equals((Object)ActionResultType.SUCCESS)) {
            player.func_184821_cY();
        }
        if (result.equals((Object)ActionResultType.SUCCESS)) {
            this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
        }
        return result;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.getEffectLevel(itemStack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)itemStack) > 0) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStack);
    }

    public ActionResultType flattenPath(PlayerEntity player, World world, BlockPos pos, Hand hand, Direction facing) {
        BlockState blockstate;
        ItemStack itemStack = player.func_184586_b(hand);
        if (facing != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a()) && (blockstate = flattenLookup.get(world.func_180495_p(pos).func_177230_c())) != null) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, blockstate, 11);
                this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
                this.tickProgression((LivingEntity)player, itemStack, this.blockDestroyDamage);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType tillBlock(ItemUseContext context) {
        BlockState newState;
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return ActionResultType.FAIL;
        }
        UseHoeEvent event = new UseHoeEvent(context);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return ActionResultType.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
            this.tickProgression((LivingEntity)player, itemStack, this.blockDestroyDamage);
            return ActionResultType.SUCCESS;
        }
        if (facing != Direction.DOWN && world.func_175623_d(pos.func_177984_a()) && (newState = tillLookup.get(world.func_180495_p(pos).func_177230_c())) != null) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, newState, 11);
                this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType stripBlock(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState blockState = world.func_180495_p(pos = context.func_195995_a());
        Block block = stripLookup.get(blockState.func_177230_c());
        if (block != null) {
            PlayerEntity player = context.func_195999_j();
            world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                this.applyDamage(this.blockDestroyDamage, context.func_195996_i(), (LivingEntity)player);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType denailBlock(PlayerEntity player, World world, BlockPos pos, Hand hand, Direction facing) {
        boolean success;
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return ActionResultType.FAIL;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (this.canDenail(blockState, world, pos) && (success = ItemEffectHandler.breakBlock(world, player, player.func_184586_b(hand), pos, blockState, true))) {
            this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
            this.tickProgression((LivingEntity)player, itemStack, this.blockDestroyDamage);
            player.func_184821_cY();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean canDenail(BlockState blockState, World world, BlockPos pos) {
        return blockState.func_177230_c().getTags().contains(nailedTag);
    }

    private void sweepAttack(ItemStack itemStack, LivingEntity target, LivingEntity attacker, int sweepingLevel) {
        float cooldown = 1.0f;
        if (attacker instanceof PlayerEntity) {
            cooldown = ItemModularHandheld.getCooledAttackStrength(itemStack);
        }
        if ((double)cooldown > 0.9) {
            float damage = (float)Math.max((this.getDamageModifier(itemStack) + 1.0) * (double)((float)sweepingLevel * 0.125f), 1.0);
            float knockback = sweepingLevel > 4 ? (float)(this.getEnchantmentLevelFromImprovements(itemStack, Enchantments.field_180313_o) + 1) * 0.5f : 0.5f;
            double range = 1.0 + this.getEffectEfficiency(itemStack, ItemEffect.sweeping);
            attacker.field_70170_p.func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(range, 0.25, range)).stream().filter(entity -> entity != attacker).filter(entity -> !attacker.func_184191_r((Entity)entity)).filter(entity -> attacker.func_70068_e((Entity)entity) < (range + 2.0) * (range + 2.0)).forEach(entity -> {
                entity.func_70653_a((Entity)attacker, knockback, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                if (attacker instanceof PlayerEntity) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
                } else {
                    entity.func_70097_a(DamageSource.func_188403_a((Entity)attacker, (LivingEntity)entity), damage);
                }
            });
            attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
            CastOptional.cast(attacker, PlayerEntity.class).ifPresent(PlayerEntity::func_184810_cG);
        }
    }

    public static void spawnSweepParticles(World world, double x, double y, double z, double xOffset, double zOffset) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197603_N, x, y, z, 1, xOffset, 0.0, zOffset, 0.0);
        }
    }

    public static void spawnSweepParticles(LivingEntity attacker) {
        double xOffset = -MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
        double zOffset = MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
        ItemModularHandheld.spawnSweepParticles(attacker.field_70170_p, attacker.field_70165_t + xOffset, attacker.field_70163_u + (double)attacker.func_213302_cg() * 0.5, attacker.field_70161_v + zOffset, xOffset, zOffset);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.getEffectLevel(stack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)stack) > 0) {
            return UseAction.SPEAR;
        }
        return super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.getEffectLevel(stack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)stack) > 0) {
            return 72000;
        }
        return 0;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int ticksUsed = this.func_77626_a(stack) - timeLeft;
            if (ticksUsed >= 10) {
                this.applyUsageEffects((LivingEntity)player, stack, 2.0);
                int riptideLevel = EnchantmentHelper.func_203190_g((ItemStack)stack);
                if (riptideLevel <= 0 || player.func_70026_G()) {
                    if (!world.field_72995_K) {
                        this.applyDamage(1, stack, (LivingEntity)player);
                        if (riptideLevel == 0) {
                            ThrownModularItemEntity projectileEntity = new ThrownModularItemEntity(world, (LivingEntity)player, stack);
                            projectileEntity.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                            if (player.field_71075_bZ.field_75098_d) {
                                projectileEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                            }
                            world.func_217376_c((Entity)projectileEntity);
                            world.func_217384_a(null, (Entity)projectileEntity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.field_71071_by.func_184437_d(stack);
                            }
                        }
                    }
                    if (riptideLevel > 0) {
                        float yaw = player.field_70177_z;
                        float pitch = player.field_70125_A;
                        float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                        float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                        float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                        float velocityMultiplier = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                        player.func_70024_g((double)(x *= velocityMultiplier), (double)(y *= velocityMultiplier), (double)(z *= velocityMultiplier));
                        player.func_204803_n(20);
                        if (player.field_70122_E) {
                            player.func_213315_a(MoverType.SELF, new Vec3d(0.0, 1.1999999, 0.0));
                        }
                        SoundEvent soundEvent = riptideLevel >= 3 ? SoundEvents.field_203273_io : (riptideLevel == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
                        world.func_217384_a(null, (Entity)player, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        this.setCooledAttackStrength(stack, player.func_184825_o(0.5f));
        return false;
    }

    public void setCooledAttackStrength(ItemStack itemStack, float strength) {
        NBTHelper.getTag(itemStack).func_74776_a("cooledStrength", strength);
    }

    public static float getCooledAttackStrength(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74760_g("cooledStrength");
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        int armor;
        Multimap multimap = super.getAttributeModifiers(slot, itemStack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "tetra.damage_mod", this.getDamageModifier(itemStack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "tetra.speed_mod", this.getSpeedModifier(itemStack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_MODIFIER, "tetra.reach_mod", this.getRangeModifier(itemStack), AttributeModifier.Operation.ADDITION));
        }
        if ((slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) && (armor = this.getEffectLevel(itemStack, ItemEffect.armor)) > 0) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIER, "tetra.armor_mod", (double)armor, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageModifier(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        double damageModifier = this.getAllModules(itemStack).stream().mapToDouble(itemModule -> itemModule.getDamageModifier(itemStack)).sum();
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damage).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damageMultiplier).reduce(damageModifier, (a, b) -> a * b);
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getDamageMultiplierModifier(itemStack)).reduce(damageModifier, (a, b) -> a * b);
    }

    public static double getDamageModifierStatic(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModularHandheld) {
            return ((ItemModularHandheld)itemStack.func_77973_b()).getDamageModifier(itemStack);
        }
        return 0.0;
    }

    public double getSpeedModifier(ItemStack itemStack) {
        double speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedModifier(itemStack)).reduce(-2.4, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeed).reduce(speedModifier, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeedMultiplier).reduce(speedModifier, (a, b) -> a * b);
        speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedMultiplierModifier(itemStack)).reduce(speedModifier, (a, b) -> a * b);
        if ((speedModifier *= this.getCounterWeightMultiplier(itemStack)) < -4.0) {
            speedModifier = -3.9;
        }
        return speedModifier;
    }

    public double getCounterWeightMultiplier(ItemStack itemStack) {
        int counterWeightLevel = this.getEffectLevel(itemStack, ItemEffect.counterweight);
        if (counterWeightLevel > 0) {
            int integrityCost = ItemModularHandheld.getIntegrityCost(itemStack);
            return 0.5 + (double)Math.abs(counterWeightLevel + integrityCost) * 0.2;
        }
        return 1.0;
    }

    public static double getSpeedModifierStatic(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModularHandheld) {
            return ((ItemModularHandheld)itemStack.func_77973_b()).getSpeedModifier(itemStack);
        }
        return 2.0;
    }

    public double getRangeModifier(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getRangeModifier(itemStack)).reduce(0.0, Double::sum);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!this.isBroken(stack)) {
            return this.getCapabilities(stack).stream().map(Enum::toString).map(ToolType::get).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        int capabilityLevel;
        if (!this.isBroken(stack) && (capabilityLevel = this.getCapabilityLevel(stack, tool)) > 0) {
            return capabilityLevel - 1;
        }
        return -1;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (this.getHarvestLevel(stack, state.getHarvestTool(), null, state) >= state.getHarvestLevel()) {
            return true;
        }
        if (state.getHarvestTool() != ToolType.PICKAXE && pickaxeHarvestMaterials.contains(state.func_185904_a())) {
            return this.getHarvestLevel(stack, ToolType.PICKAXE, null, null) >= 0;
        }
        if (state.getHarvestTool() != ToolType.AXE && axeHarvestMaterials.contains(state.func_185904_a())) {
            return this.getHarvestLevel(stack, ToolType.AXE, null, null) >= 0;
        }
        if (state.getHarvestTool() != ToolType.SHOVEL && shovelHarvestBlocks.contains(state.func_177230_c())) {
            return this.getHarvestLevel(stack, ToolType.SHOVEL, null, null) >= 0;
        }
        if (state.getHarvestTool() != ToolTypes.cut && cuttingHarvestBlocks.contains(state.func_177230_c())) {
            return this.getHarvestLevel(stack, ToolTypes.cut, null, null) >= 0;
        }
        return false;
    }

    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        if (!this.isBroken(itemStack)) {
            ToolType tool = ItemModularHandheld.getEffectiveTool(blockState);
            float speed = (float)(4.0 + this.getSpeedModifier(itemStack));
            speed = tool != null ? (speed *= this.getCapabilityEfficiency(itemStack, tool)) : (speed *= this.getToolTypes(itemStack).stream().filter(arg_0 -> ((BlockState)blockState).isToolEffective(arg_0)).map(toolType -> Float.valueOf(this.getCapabilityEfficiency(itemStack, (ToolType)toolType))).max(Comparator.naturalOrder()).orElse(Float.valueOf(0.0f)).floatValue());
            if (ToolTypes.cut.equals(tool) && blockState.func_177230_c().equals(Blocks.field_196553_aF)) {
                speed *= 10.0f;
            }
            if (speed < 1.0f) {
                return 1.0f;
            }
            return speed;
        }
        return 1.0f;
    }

    public static boolean isToolEffective(ToolType toolType, BlockState blockState) {
        if (axeHarvestMaterials.contains(blockState.func_185904_a()) && ToolType.AXE.equals(toolType)) {
            return true;
        }
        if (pickaxeHarvestMaterials.contains(blockState.func_185904_a()) && ToolType.PICKAXE.equals(toolType)) {
            return true;
        }
        if (cuttingHarvestBlocks.contains(blockState.func_177230_c()) && ToolTypes.cut.equals(toolType)) {
            return true;
        }
        if (shovelHarvestBlocks.contains(blockState.func_177230_c()) && ToolType.SHOVEL.equals(toolType)) {
            return true;
        }
        if (axeDestroyBlocks.contains(blockState.func_177230_c()) && ToolType.AXE.equals(toolType)) {
            return true;
        }
        if (pickaxeDestroyBlocks.contains(blockState.func_177230_c()) && ToolType.PICKAXE.equals(toolType)) {
            return true;
        }
        if (cuttingDestroyMaterials.contains(blockState.func_185904_a()) || cuttingDestroyTags.stream().anyMatch(tag -> blockState.func_177230_c().func_203417_a(tag)) && ToolTypes.cut.equals(toolType)) {
            return true;
        }
        if (shovelDestroyBlocks.contains(blockState.func_177230_c()) && ToolType.SHOVEL.equals(toolType)) {
            return true;
        }
        return toolType.equals(blockState.getHarvestTool());
    }

    public static ToolType getEffectiveTool(BlockState blockState) {
        ToolType tool = blockState.getHarvestTool();
        if (tool != null) {
            return tool;
        }
        if (axeHarvestMaterials.contains(blockState.func_185904_a())) {
            return ToolType.AXE;
        }
        if (pickaxeHarvestMaterials.contains(blockState.func_185904_a())) {
            return ToolType.PICKAXE;
        }
        if (cuttingHarvestBlocks.contains(blockState.func_177230_c())) {
            return ToolTypes.cut;
        }
        if (shovelHarvestBlocks.contains(blockState.func_177230_c())) {
            return ToolType.SHOVEL;
        }
        if (axeDestroyBlocks.contains(blockState.func_177230_c())) {
            return ToolType.AXE;
        }
        if (pickaxeDestroyBlocks.contains(blockState.func_177230_c())) {
            return ToolType.PICKAXE;
        }
        if (cuttingDestroyMaterials.contains(blockState.func_185904_a()) || cuttingDestroyTags.stream().anyMatch(tag -> blockState.func_177230_c().func_203417_a(tag))) {
            return ToolTypes.cut;
        }
        if (shovelDestroyBlocks.contains(blockState.func_177230_c())) {
            return ToolType.SHOVEL;
        }
        return null;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Override
    public ItemStack onCraftConsumeCapability(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, Capability capability, int capabilityLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(capabilityLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, capabilityLevel * 2);
        }
        return super.onCraftConsumeCapability(providerStack, targetStack, player, capability, capabilityLevel, consumeResources);
    }

    @Override
    public ItemStack onActionConsumeCapability(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, Capability capability, int capabilityLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(capabilityLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, capabilityLevel * 2);
        }
        return super.onCraftConsumeCapability(providerStack, targetStack, player, capability, capabilityLevel, consumeResources);
    }
}

