/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class ThrownModularItemEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "thrown_modular_item";
    public static final String stackKey = "stack";
    public static final String dealtDamageKey = "DealtDamage";
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(ThrownModularItemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private ItemStack thrownStack = new ItemStack((IItemProvider)Items.field_203184_eO);
    @ObjectHolder(value="tetra:thrown_modular_item")
    public static EntityType<ThrownModularItemEntity> type;
    private boolean dealtDamage;
    public int returningTicks;

    public ThrownModularItemEntity(EntityType<? extends ThrownModularItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrownModularItemEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(type, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ThrownModularItemEntity(World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public ThrownModularItemEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.func_212360_k();
        if ((this.dealtDamage || this.func_203047_q()) && shooter != null) {
            byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyaltyLevel > 0) {
                this.func_203045_n(true);
                Vec3d vec3d = new Vec3d(shooter.field_70165_t - this.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - this.field_70163_u, shooter.field_70161_v - this.field_70161_v);
                this.field_70163_u += vec3d.field_72448_b * 0.015 * (double)loyaltyLevel;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.field_70163_u;
                }
                double speed = 0.05 * (double)loyaltyLevel;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(speed)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_212360_k();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d startVec, Vec3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_184549_a(RayTraceResult rayTraceResult) {
        super.func_184549_a(rayTraceResult);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !this.dealtDamage) {
            float destroySpeed;
            BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            Entity shooter = this.func_212360_k();
            BlockState blockState = this.field_70170_p.func_180495_p(pos);
            if (ForgeHooks.canToolHarvestBlock((IWorldReader)this.field_70170_p, (BlockPos)pos, (ItemStack)this.thrownStack) && shooter instanceof PlayerEntity && (destroySpeed = CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).map(item -> Float.valueOf(item.func_150893_a(this.thrownStack, blockState))).orElse(Float.valueOf(1.0f)).floatValue()) > blockState.func_185887_b((IBlockReader)this.field_70170_p, pos)) {
                if (shooter instanceof ServerPlayerEntity) {
                    ItemEffectHandler.sendEventToPlayer((ServerPlayerEntity)shooter, 2001, pos, Block.func_196246_j((BlockState)blockState));
                }
                CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> item.applyBreakEffects(this.thrownStack, this.field_70170_p, blockState, pos, (LivingEntity)((PlayerEntity)shooter)));
                this.breakBlock((PlayerEntity)shooter, pos, blockState);
                Vec3i faceVec = ((BlockRayTraceResult)rayTraceResult).func_216354_b().func_176730_m();
                this.func_213317_d(new Vec3d(faceVec).func_186678_a(0.1));
                this.dealtDamage = true;
            }
        }
    }

    private void breakBlock(PlayerEntity shooter, BlockPos pos, BlockState blockState) {
        ItemStack currentItem = shooter.func_184614_ca();
        shooter.func_184611_a(Hand.MAIN_HAND, this.thrownStack);
        ItemEffectHandler.breakBlock(this.field_70170_p, shooter, this.thrownStack, pos, blockState, true);
        shooter.func_184611_a(Hand.MAIN_HAND, currentItem);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        BlockPos blockpos;
        Entity target = p_213868_1_.func_216348_a();
        Entity shooter = this.func_212360_k();
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)(shooter == null ? this : shooter));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        float damage = 8.0f;
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        if (target.func_70097_a(damagesource, damage) && target instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)target;
            if (shooter instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)shooter);
                EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)livingentity1);
            }
            this.func_184548_a(livingentity1);
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.thrownStack) && this.field_70170_p.func_217337_f(blockpos = target.func_180425_c())) {
            LightningBoltEntity lightningboltentity = new LightningBoltEntity(this.field_70170_p, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, false);
            lightningboltentity.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
            ((ServerWorld)this.field_70170_p).func_217468_a(lightningboltentity);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        if (target instanceof LivingEntity && shooter instanceof LivingEntity) {
            CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> item.applyHitEffects(this.thrownStack, (LivingEntity)target, (LivingEntity)shooter));
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_212360_k();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(stackKey, 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(stackKey));
        }
        this.dealtDamage = compound.func_74767_n(dealtDamageKey);
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a(stackKey, (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a(dealtDamageKey, this.dealtDamage);
    }

    protected void func_203048_f() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_203048_f();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.thrownStack);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.thrownStack = buffer.func_150791_c();
    }
}

