/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.bow;

import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiRoot;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;

public class GuiRangedProgress
extends GuiRoot {
    private static final int width = 16;
    private GuiElement container = new GuiElement(-1, 20, 16, 2).setAttachment(GuiAttachment.middleCenter).setOpacity(0.0f);
    private GuiRect bar;
    private GuiRect overbowBar;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;

    public GuiRangedProgress(Minecraft mc) {
        super(mc);
        this.addChild(this.container);
        this.container.addChild(new GuiRect(0, 0, 16, 2, 0xFFFFFF).setOpacity(0.2f));
        this.bar = new GuiRect(0, 0, 0, 2, 0xFFFFFF);
        this.bar.setOpacity(0.6f);
        this.container.addChild((GuiElement)this.bar);
        this.overbowBar = new GuiRect(0, 0, 0, 2, 0xFF5555);
        this.overbowBar.setAttachment(GuiAttachment.bottomRight);
        this.container.addChild((GuiElement)this.overbowBar);
        this.showAnimation = new KeyframeAnimation(60, this.container).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.hideAnimation = new KeyframeAnimation(100, this.container).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-2.0f)}).withDelay(1000);
    }

    public void setProgress(float progress, float overbowCap, double overbowRate) {
        if (progress > 0.0f) {
            this.bar.setWidth(MathHelper.func_76125_a((int)((int)(progress * 16.0f)), (int)0, (int)16));
            if (progress > 1.0f && overbowCap > 0.0f) {
                this.overbowBar.setWidth((int)(16.0f * (1.0f - ModularBowItem.getProgressOverbowed(progress, overbowCap, (float)overbowRate))));
            } else {
                this.overbowBar.setWidth(0);
            }
            if (!this.showAnimation.isActive() && this.container.getOpacity() < 1.0f) {
                this.showAnimation.start();
            }
            this.hideAnimation.stop();
        } else {
            if (!this.hideAnimation.isActive() && this.container.getOpacity() > 0.0f) {
                this.hideAnimation.start();
            }
            this.showAnimation.stop();
        }
    }

    public void draw() {
        if (this.isVisible()) {
            MainWindow window = this.mc.field_195558_d;
            int width = window.func_198107_o();
            int height = window.func_198087_p();
            int mouseX = (int)(this.mc.field_71417_B.func_198024_e() * (double)window.func_198107_o() / (double)window.func_198105_m());
            int mouseY = (int)(this.mc.field_71417_B.func_198026_f() * (double)window.func_198087_p() / (double)window.func_198083_n());
            this.drawChildren(width / 2, height / 2, 0, 0, mouseX, mouseY, 1.0f);
        }
    }
}

